/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.RejectGroupingRecommendationEntriesCopier;
import software.amazon.awssdk.services.resiliencehub.model.RejectGroupingRecommendationEntry;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RejectResourceGroupingRecommendationsRequest
extends ResiliencehubRequest
implements ToCopyableBuilder<Builder, RejectResourceGroupingRecommendationsRequest> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(RejectResourceGroupingRecommendationsRequest.getter(RejectResourceGroupingRecommendationsRequest::appArn)).setter(RejectResourceGroupingRecommendationsRequest.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<List<RejectGroupingRecommendationEntry>> ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entries").getter(RejectResourceGroupingRecommendationsRequest.getter(RejectResourceGroupingRecommendationsRequest::entries)).setter(RejectResourceGroupingRecommendationsRequest.setter(Builder::entries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RejectGroupingRecommendationEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, ENTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("appArn", APP_ARN_FIELD);
            this.put("entries", ENTRIES_FIELD);
        }
    });
    private final String appArn;
    private final List<RejectGroupingRecommendationEntry> entries;

    private RejectResourceGroupingRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.entries = builder.entries;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final boolean hasEntries() {
        return this.entries != null && !(this.entries instanceof SdkAutoConstructList);
    }

    public final List<RejectGroupingRecommendationEntry> entries() {
        return this.entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntries() ? this.entries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectResourceGroupingRecommendationsRequest)) {
            return false;
        }
        RejectResourceGroupingRecommendationsRequest other = (RejectResourceGroupingRecommendationsRequest)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && this.hasEntries() == other.hasEntries() && Objects.equals(this.entries(), other.entries());
    }

    public final String toString() {
        return ToString.builder((String)"RejectResourceGroupingRecommendationsRequest").add("AppArn", (Object)this.appArn()).add("Entries", this.hasEntries() ? this.entries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "entries": {
                return Optional.ofNullable(clazz.cast(this.entries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RejectResourceGroupingRecommendationsRequest, T> g) {
        return obj -> g.apply((RejectResourceGroupingRecommendationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubRequest.BuilderImpl
    implements Builder {
        private String appArn;
        private List<RejectGroupingRecommendationEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RejectResourceGroupingRecommendationsRequest model) {
            super(model);
            this.appArn(model.appArn);
            this.entries(model.entries);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final List<RejectGroupingRecommendationEntry.Builder> getEntries() {
            List<RejectGroupingRecommendationEntry.Builder> result = RejectGroupingRecommendationEntriesCopier.copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<RejectGroupingRecommendationEntry.BuilderImpl> entries) {
            this.entries = RejectGroupingRecommendationEntriesCopier.copyFromBuilder(entries);
        }

        @Override
        public final Builder entries(Collection<RejectGroupingRecommendationEntry> entries) {
            this.entries = RejectGroupingRecommendationEntriesCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(RejectGroupingRecommendationEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<RejectGroupingRecommendationEntry.Builder> ... entries) {
            this.entries(Stream.of(entries).map(c -> (RejectGroupingRecommendationEntry)((RejectGroupingRecommendationEntry.Builder)RejectGroupingRecommendationEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RejectResourceGroupingRecommendationsRequest build() {
            return new RejectResourceGroupingRecommendationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RejectResourceGroupingRecommendationsRequest> {
        public Builder appArn(String var1);

        public Builder entries(Collection<RejectGroupingRecommendationEntry> var1);

        public Builder entries(RejectGroupingRecommendationEntry ... var1);

        public Builder entries(Consumer<RejectGroupingRecommendationEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

