/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppsRequest
extends ResiliencehubRequest
implements ToCopyableBuilder<Builder, ListAppsRequest> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(ListAppsRequest.getter(ListAppsRequest::appArn)).setter(ListAppsRequest.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("appArn").build()}).build();
    private static final SdkField<String> AWS_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsApplicationArn").getter(ListAppsRequest.getter(ListAppsRequest::awsApplicationArn)).setter(ListAppsRequest.setter(Builder::awsApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("awsApplicationArn").build()}).build();
    private static final SdkField<Instant> FROM_LAST_ASSESSMENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("fromLastAssessmentTime").getter(ListAppsRequest.getter(ListAppsRequest::fromLastAssessmentTime)).setter(ListAppsRequest.setter(Builder::fromLastAssessmentTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("fromLastAssessmentTime").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAppsRequest.getter(ListAppsRequest::maxResults)).setter(ListAppsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ListAppsRequest.getter(ListAppsRequest::name)).setter(ListAppsRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAppsRequest.getter(ListAppsRequest::nextToken)).setter(ListAppsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("reverseOrder").getter(ListAppsRequest.getter(ListAppsRequest::reverseOrder)).setter(ListAppsRequest.setter(Builder::reverseOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reverseOrder").build()}).build();
    private static final SdkField<Instant> TO_LAST_ASSESSMENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("toLastAssessmentTime").getter(ListAppsRequest.getter(ListAppsRequest::toLastAssessmentTime)).setter(ListAppsRequest.setter(Builder::toLastAssessmentTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("toLastAssessmentTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, AWS_APPLICATION_ARN_FIELD, FROM_LAST_ASSESSMENT_TIME_FIELD, MAX_RESULTS_FIELD, NAME_FIELD, NEXT_TOKEN_FIELD, REVERSE_ORDER_FIELD, TO_LAST_ASSESSMENT_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("appArn", APP_ARN_FIELD);
            this.put("awsApplicationArn", AWS_APPLICATION_ARN_FIELD);
            this.put("fromLastAssessmentTime", FROM_LAST_ASSESSMENT_TIME_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("name", NAME_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("reverseOrder", REVERSE_ORDER_FIELD);
            this.put("toLastAssessmentTime", TO_LAST_ASSESSMENT_TIME_FIELD);
        }
    });
    private final String appArn;
    private final String awsApplicationArn;
    private final Instant fromLastAssessmentTime;
    private final Integer maxResults;
    private final String name;
    private final String nextToken;
    private final Boolean reverseOrder;
    private final Instant toLastAssessmentTime;

    private ListAppsRequest(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.awsApplicationArn = builder.awsApplicationArn;
        this.fromLastAssessmentTime = builder.fromLastAssessmentTime;
        this.maxResults = builder.maxResults;
        this.name = builder.name;
        this.nextToken = builder.nextToken;
        this.reverseOrder = builder.reverseOrder;
        this.toLastAssessmentTime = builder.toLastAssessmentTime;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String awsApplicationArn() {
        return this.awsApplicationArn;
    }

    public final Instant fromLastAssessmentTime() {
        return this.fromLastAssessmentTime;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String name() {
        return this.name;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Boolean reverseOrder() {
        return this.reverseOrder;
    }

    public final Instant toLastAssessmentTime() {
        return this.toLastAssessmentTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromLastAssessmentTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.reverseOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.toLastAssessmentTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppsRequest)) {
            return false;
        }
        ListAppsRequest other = (ListAppsRequest)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.awsApplicationArn(), other.awsApplicationArn()) && Objects.equals(this.fromLastAssessmentTime(), other.fromLastAssessmentTime()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.reverseOrder(), other.reverseOrder()) && Objects.equals(this.toLastAssessmentTime(), other.toLastAssessmentTime());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppsRequest").add("AppArn", (Object)this.appArn()).add("AwsApplicationArn", (Object)this.awsApplicationArn()).add("FromLastAssessmentTime", (Object)this.fromLastAssessmentTime()).add("MaxResults", (Object)this.maxResults()).add("Name", (Object)this.name()).add("NextToken", (Object)this.nextToken()).add("ReverseOrder", (Object)this.reverseOrder()).add("ToLastAssessmentTime", (Object)this.toLastAssessmentTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "awsApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.awsApplicationArn()));
            }
            case "fromLastAssessmentTime": {
                return Optional.ofNullable(clazz.cast(this.fromLastAssessmentTime()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "reverseOrder": {
                return Optional.ofNullable(clazz.cast(this.reverseOrder()));
            }
            case "toLastAssessmentTime": {
                return Optional.ofNullable(clazz.cast(this.toLastAssessmentTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAppsRequest, T> g) {
        return obj -> g.apply((ListAppsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubRequest.BuilderImpl
    implements Builder {
        private String appArn;
        private String awsApplicationArn;
        private Instant fromLastAssessmentTime;
        private Integer maxResults;
        private String name;
        private String nextToken;
        private Boolean reverseOrder;
        private Instant toLastAssessmentTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppsRequest model) {
            super(model);
            this.appArn(model.appArn);
            this.awsApplicationArn(model.awsApplicationArn);
            this.fromLastAssessmentTime(model.fromLastAssessmentTime);
            this.maxResults(model.maxResults);
            this.name(model.name);
            this.nextToken(model.nextToken);
            this.reverseOrder(model.reverseOrder);
            this.toLastAssessmentTime(model.toLastAssessmentTime);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAwsApplicationArn() {
            return this.awsApplicationArn;
        }

        public final void setAwsApplicationArn(String awsApplicationArn) {
            this.awsApplicationArn = awsApplicationArn;
        }

        @Override
        public final Builder awsApplicationArn(String awsApplicationArn) {
            this.awsApplicationArn = awsApplicationArn;
            return this;
        }

        public final Instant getFromLastAssessmentTime() {
            return this.fromLastAssessmentTime;
        }

        public final void setFromLastAssessmentTime(Instant fromLastAssessmentTime) {
            this.fromLastAssessmentTime = fromLastAssessmentTime;
        }

        @Override
        public final Builder fromLastAssessmentTime(Instant fromLastAssessmentTime) {
            this.fromLastAssessmentTime = fromLastAssessmentTime;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getReverseOrder() {
            return this.reverseOrder;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        public final Instant getToLastAssessmentTime() {
            return this.toLastAssessmentTime;
        }

        public final void setToLastAssessmentTime(Instant toLastAssessmentTime) {
            this.toLastAssessmentTime = toLastAssessmentTime;
        }

        @Override
        public final Builder toLastAssessmentTime(Instant toLastAssessmentTime) {
            this.toLastAssessmentTime = toLastAssessmentTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAppsRequest build() {
            return new ListAppsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppsRequest> {
        public Builder appArn(String var1);

        public Builder awsApplicationArn(String var1);

        public Builder fromLastAssessmentTime(Instant var1);

        public Builder maxResults(Integer var1);

        public Builder name(String var1);

        public Builder nextToken(String var1);

        public Builder reverseOrder(Boolean var1);

        public Builder toLastAssessmentTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

