/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.PhysicalResource;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAppVersionResourceResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, DeleteAppVersionResourceResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(DeleteAppVersionResourceResponse.getter(DeleteAppVersionResourceResponse::appArn)).setter(DeleteAppVersionResourceResponse.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appVersion").getter(DeleteAppVersionResourceResponse.getter(DeleteAppVersionResourceResponse::appVersion)).setter(DeleteAppVersionResourceResponse.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<PhysicalResource> PHYSICAL_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("physicalResource").getter(DeleteAppVersionResourceResponse.getter(DeleteAppVersionResourceResponse::physicalResource)).setter(DeleteAppVersionResourceResponse.setter(Builder::physicalResource)).constructor(PhysicalResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalResource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, APP_VERSION_FIELD, PHYSICAL_RESOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("appArn", APP_ARN_FIELD);
            this.put("appVersion", APP_VERSION_FIELD);
            this.put("physicalResource", PHYSICAL_RESOURCE_FIELD);
        }
    });
    private final String appArn;
    private final String appVersion;
    private final PhysicalResource physicalResource;

    private DeleteAppVersionResourceResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.physicalResource = builder.physicalResource;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String appVersion() {
        return this.appVersion;
    }

    public final PhysicalResource physicalResource() {
        return this.physicalResource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAppVersionResourceResponse)) {
            return false;
        }
        DeleteAppVersionResourceResponse other = (DeleteAppVersionResourceResponse)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.appVersion(), other.appVersion()) && Objects.equals(this.physicalResource(), other.physicalResource());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAppVersionResourceResponse").add("AppArn", (Object)this.appArn()).add("AppVersion", (Object)this.appVersion()).add("PhysicalResource", (Object)this.physicalResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "physicalResource": {
                return Optional.ofNullable(clazz.cast(this.physicalResource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAppVersionResourceResponse, T> g) {
        return obj -> g.apply((DeleteAppVersionResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String appArn;
        private String appVersion;
        private PhysicalResource physicalResource;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAppVersionResourceResponse model) {
            super(model);
            this.appArn(model.appArn);
            this.appVersion(model.appVersion);
            this.physicalResource(model.physicalResource);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final PhysicalResource.Builder getPhysicalResource() {
            return this.physicalResource != null ? this.physicalResource.toBuilder() : null;
        }

        public final void setPhysicalResource(PhysicalResource.BuilderImpl physicalResource) {
            this.physicalResource = physicalResource != null ? physicalResource.build() : null;
        }

        @Override
        public final Builder physicalResource(PhysicalResource physicalResource) {
            this.physicalResource = physicalResource;
            return this;
        }

        @Override
        public DeleteAppVersionResourceResponse build() {
            return new DeleteAppVersionResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAppVersionResourceResponse> {
        public Builder appArn(String var1);

        public Builder appVersion(String var1);

        public Builder physicalResource(PhysicalResource var1);

        default public Builder physicalResource(Consumer<PhysicalResource.Builder> physicalResource) {
            return this.physicalResource((PhysicalResource)((PhysicalResource.Builder)PhysicalResource.builder().applyMutation(physicalResource)).build());
        }
    }
}

