/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataLocationConstraint {
    ANY_LOCATION("AnyLocation"),
    SAME_CONTINENT("SameContinent"),
    SAME_COUNTRY("SameCountry"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataLocationConstraint> VALUE_MAP;
    private final String value;

    private DataLocationConstraint(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataLocationConstraint fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataLocationConstraint> knownValues() {
        EnumSet<DataLocationConstraint> knownValues = EnumSet.allOf(DataLocationConstraint.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataLocationConstraint.class, DataLocationConstraint::toString);
    }
}

