/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AssessmentStatus {
    PENDING("Pending"),
    IN_PROGRESS("InProgress"),
    FAILED("Failed"),
    SUCCESS("Success"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AssessmentStatus> VALUE_MAP;
    private final String value;

    private AssessmentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssessmentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssessmentStatus> knownValues() {
        EnumSet<AssessmentStatus> knownValues = EnumSet.allOf(AssessmentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AssessmentStatus.class, AssessmentStatus::toString);
    }
}

