/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.AssessmentStatus;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAppAssessmentResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, DeleteAppAssessmentResponse> {
    private static final SdkField<String> ASSESSMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentArn").getter(DeleteAppAssessmentResponse.getter(DeleteAppAssessmentResponse::assessmentArn)).setter(DeleteAppAssessmentResponse.setter(Builder::assessmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentArn").build()}).build();
    private static final SdkField<String> ASSESSMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentStatus").getter(DeleteAppAssessmentResponse.getter(DeleteAppAssessmentResponse::assessmentStatusAsString)).setter(DeleteAppAssessmentResponse.setter(Builder::assessmentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ARN_FIELD, ASSESSMENT_STATUS_FIELD));
    private final String assessmentArn;
    private final String assessmentStatus;

    private DeleteAppAssessmentResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentArn = builder.assessmentArn;
        this.assessmentStatus = builder.assessmentStatus;
    }

    public final String assessmentArn() {
        return this.assessmentArn;
    }

    public final AssessmentStatus assessmentStatus() {
        return AssessmentStatus.fromValue(this.assessmentStatus);
    }

    public final String assessmentStatusAsString() {
        return this.assessmentStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAppAssessmentResponse)) {
            return false;
        }
        DeleteAppAssessmentResponse other = (DeleteAppAssessmentResponse)((Object)obj);
        return Objects.equals(this.assessmentArn(), other.assessmentArn()) && Objects.equals(this.assessmentStatusAsString(), other.assessmentStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAppAssessmentResponse").add("AssessmentArn", (Object)this.assessmentArn()).add("AssessmentStatus", (Object)this.assessmentStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentArn": {
                return Optional.ofNullable(clazz.cast(this.assessmentArn()));
            }
            case "assessmentStatus": {
                return Optional.ofNullable(clazz.cast(this.assessmentStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAppAssessmentResponse, T> g) {
        return obj -> g.apply((DeleteAppAssessmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String assessmentArn;
        private String assessmentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAppAssessmentResponse model) {
            super(model);
            this.assessmentArn(model.assessmentArn);
            this.assessmentStatus(model.assessmentStatus);
        }

        public final String getAssessmentArn() {
            return this.assessmentArn;
        }

        public final void setAssessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
        }

        @Override
        public final Builder assessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
            return this;
        }

        public final String getAssessmentStatus() {
            return this.assessmentStatus;
        }

        public final void setAssessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
        }

        @Override
        public final Builder assessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
            return this;
        }

        @Override
        public final Builder assessmentStatus(AssessmentStatus assessmentStatus) {
            this.assessmentStatus(assessmentStatus == null ? null : assessmentStatus.toString());
            return this;
        }

        @Override
        public DeleteAppAssessmentResponse build() {
            return new DeleteAppAssessmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAppAssessmentResponse> {
        public Builder assessmentArn(String var1);

        public Builder assessmentStatus(String var1);

        public Builder assessmentStatus(AssessmentStatus var1);
    }
}

