/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.AppComponentCompliance;
import software.amazon.awssdk.services.resiliencehub.model.ComponentCompliancesListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppComponentCompliancesResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListAppComponentCompliancesResponse> {
    private static final SdkField<List<AppComponentCompliance>> COMPONENT_COMPLIANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("componentCompliances").getter(ListAppComponentCompliancesResponse.getter(ListAppComponentCompliancesResponse::componentCompliances)).setter(ListAppComponentCompliancesResponse.setter(Builder::componentCompliances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentCompliances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppComponentCompliance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAppComponentCompliancesResponse.getter(ListAppComponentCompliancesResponse::nextToken)).setter(ListAppComponentCompliancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_COMPLIANCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AppComponentCompliance> componentCompliances;
    private final String nextToken;

    private ListAppComponentCompliancesResponse(BuilderImpl builder) {
        super(builder);
        this.componentCompliances = builder.componentCompliances;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasComponentCompliances() {
        return this.componentCompliances != null && !(this.componentCompliances instanceof SdkAutoConstructList);
    }

    public final List<AppComponentCompliance> componentCompliances() {
        return this.componentCompliances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponentCompliances() ? this.componentCompliances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppComponentCompliancesResponse)) {
            return false;
        }
        ListAppComponentCompliancesResponse other = (ListAppComponentCompliancesResponse)((Object)obj);
        return this.hasComponentCompliances() == other.hasComponentCompliances() && Objects.equals(this.componentCompliances(), other.componentCompliances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppComponentCompliancesResponse").add("ComponentCompliances", this.hasComponentCompliances() ? this.componentCompliances() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentCompliances": {
                return Optional.ofNullable(clazz.cast(this.componentCompliances()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppComponentCompliancesResponse, T> g) {
        return obj -> g.apply((ListAppComponentCompliancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private List<AppComponentCompliance> componentCompliances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppComponentCompliancesResponse model) {
            super(model);
            this.componentCompliances(model.componentCompliances);
            this.nextToken(model.nextToken);
        }

        public final List<AppComponentCompliance.Builder> getComponentCompliances() {
            List<AppComponentCompliance.Builder> result = ComponentCompliancesListCopier.copyToBuilder(this.componentCompliances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponentCompliances(Collection<AppComponentCompliance.BuilderImpl> componentCompliances) {
            this.componentCompliances = ComponentCompliancesListCopier.copyFromBuilder(componentCompliances);
        }

        @Override
        public final Builder componentCompliances(Collection<AppComponentCompliance> componentCompliances) {
            this.componentCompliances = ComponentCompliancesListCopier.copy(componentCompliances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentCompliances(AppComponentCompliance ... componentCompliances) {
            this.componentCompliances(Arrays.asList(componentCompliances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentCompliances(Consumer<AppComponentCompliance.Builder> ... componentCompliances) {
            this.componentCompliances(Stream.of(componentCompliances).map(c -> (AppComponentCompliance)((AppComponentCompliance.Builder)AppComponentCompliance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppComponentCompliancesResponse build() {
            return new ListAppComponentCompliancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppComponentCompliancesResponse> {
        public Builder componentCompliances(Collection<AppComponentCompliance> var1);

        public Builder componentCompliances(AppComponentCompliance ... var1);

        public Builder componentCompliances(Consumer<AppComponentCompliance.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

