/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubAsyncClient;
import software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsResponse;

public class ListTestRecommendationsPublisher
implements SdkPublisher<ListTestRecommendationsResponse> {
    private final ResiliencehubAsyncClient client;
    private final ListTestRecommendationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTestRecommendationsPublisher(ResiliencehubAsyncClient client, ListTestRecommendationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTestRecommendationsPublisher(ResiliencehubAsyncClient client, ListTestRecommendationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTestRecommendationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTestRecommendationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTestRecommendationsResponseFetcher
    implements AsyncPageFetcher<ListTestRecommendationsResponse> {
        private ListTestRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTestRecommendationsResponse> nextPage(ListTestRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListTestRecommendationsPublisher.this.client.listTestRecommendations(ListTestRecommendationsPublisher.this.firstRequest);
            }
            return ListTestRecommendationsPublisher.this.client.listTestRecommendations((ListTestRecommendationsRequest)((Object)ListTestRecommendationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

