/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An error that occurred during a batch operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchError implements SdkPojo, Serializable, ToCopyableBuilder<BatchError.Builder, BatchError> {
    private static final SdkField<String> ACCESSOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessorId").getter(getter(BatchError::accessorId)).setter(setter(Builder::accessorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessorId").build()).build();

    private static final SdkField<Integer> ERROR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("error")
            .getter(getter(BatchError::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(BatchError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESSOR_ID_FIELD,
            ERROR_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessorId;

    private final Integer error;

    private final String message;

    private BatchError(BuilderImpl builder) {
        this.accessorId = builder.accessorId;
        this.error = builder.error;
        this.message = builder.message;
    }

    /**
     * <p>
     * The accessor identifier that's related to the error.
     * </p>
     * 
     * @return The accessor identifier that's related to the error.
     */
    public final String accessorId() {
        return accessorId;
    }

    /**
     * <p>
     * The error code.
     * </p>
     * 
     * @return The error code.
     */
    public final Integer error() {
        return error;
    }

    /**
     * <p>
     * Description of the error.
     * </p>
     * 
     * @return Description of the error.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessorId());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchError)) {
            return false;
        }
        BatchError other = (BatchError) obj;
        return Objects.equals(accessorId(), other.accessorId()) && Objects.equals(error(), other.error())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchError").add("AccessorId", accessorId()).add("Error", error()).add("Message", message())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessorId":
            return Optional.ofNullable(clazz.cast(accessorId()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessorId", ACCESSOR_ID_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchError, T> g) {
        return obj -> g.apply((BatchError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchError> {
        /**
         * <p>
         * The accessor identifier that's related to the error.
         * </p>
         * 
         * @param accessorId
         *        The accessor identifier that's related to the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessorId(String accessorId);

        /**
         * <p>
         * The error code.
         * </p>
         * 
         * @param error
         *        The error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(Integer error);

        /**
         * <p>
         * Description of the error.
         * </p>
         * 
         * @param message
         *        Description of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String accessorId;

        private Integer error;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchError model) {
            accessorId(model.accessorId);
            error(model.error);
            message(model.message);
        }

        public final String getAccessorId() {
            return accessorId;
        }

        public final void setAccessorId(String accessorId) {
            this.accessorId = accessorId;
        }

        @Override
        public final Builder accessorId(String accessorId) {
            this.accessorId = accessorId;
            return this;
        }

        public final Integer getError() {
            return error;
        }

        public final void setError(Integer error) {
            this.error = error;
        }

        @Override
        public final Builder error(Integer error) {
            this.error = error;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BatchError build() {
            return new BatchError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
