/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.repostspace.model.BatchAddChannelRoleToAccessorsRequest;
import software.amazon.awssdk.services.repostspace.model.BatchAddChannelRoleToAccessorsResponse;
import software.amazon.awssdk.services.repostspace.model.BatchAddRoleRequest;
import software.amazon.awssdk.services.repostspace.model.BatchAddRoleResponse;
import software.amazon.awssdk.services.repostspace.model.BatchRemoveChannelRoleFromAccessorsRequest;
import software.amazon.awssdk.services.repostspace.model.BatchRemoveChannelRoleFromAccessorsResponse;
import software.amazon.awssdk.services.repostspace.model.BatchRemoveRoleRequest;
import software.amazon.awssdk.services.repostspace.model.BatchRemoveRoleResponse;
import software.amazon.awssdk.services.repostspace.model.CreateChannelRequest;
import software.amazon.awssdk.services.repostspace.model.CreateChannelResponse;
import software.amazon.awssdk.services.repostspace.model.CreateSpaceRequest;
import software.amazon.awssdk.services.repostspace.model.CreateSpaceResponse;
import software.amazon.awssdk.services.repostspace.model.DeleteSpaceRequest;
import software.amazon.awssdk.services.repostspace.model.DeleteSpaceResponse;
import software.amazon.awssdk.services.repostspace.model.DeregisterAdminRequest;
import software.amazon.awssdk.services.repostspace.model.DeregisterAdminResponse;
import software.amazon.awssdk.services.repostspace.model.GetChannelRequest;
import software.amazon.awssdk.services.repostspace.model.GetChannelResponse;
import software.amazon.awssdk.services.repostspace.model.GetSpaceRequest;
import software.amazon.awssdk.services.repostspace.model.GetSpaceResponse;
import software.amazon.awssdk.services.repostspace.model.ListChannelsRequest;
import software.amazon.awssdk.services.repostspace.model.ListChannelsResponse;
import software.amazon.awssdk.services.repostspace.model.ListSpacesRequest;
import software.amazon.awssdk.services.repostspace.model.ListSpacesResponse;
import software.amazon.awssdk.services.repostspace.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.repostspace.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.repostspace.model.RegisterAdminRequest;
import software.amazon.awssdk.services.repostspace.model.RegisterAdminResponse;
import software.amazon.awssdk.services.repostspace.model.SendInvitesRequest;
import software.amazon.awssdk.services.repostspace.model.SendInvitesResponse;
import software.amazon.awssdk.services.repostspace.model.TagResourceRequest;
import software.amazon.awssdk.services.repostspace.model.TagResourceResponse;
import software.amazon.awssdk.services.repostspace.model.UntagResourceRequest;
import software.amazon.awssdk.services.repostspace.model.UntagResourceResponse;
import software.amazon.awssdk.services.repostspace.model.UpdateChannelRequest;
import software.amazon.awssdk.services.repostspace.model.UpdateChannelResponse;
import software.amazon.awssdk.services.repostspace.model.UpdateSpaceRequest;
import software.amazon.awssdk.services.repostspace.model.UpdateSpaceResponse;
import software.amazon.awssdk.services.repostspace.paginators.ListChannelsPublisher;
import software.amazon.awssdk.services.repostspace.paginators.ListSpacesPublisher;
import software.amazon.awssdk.services.repostspace.waiters.RepostspaceAsyncWaiter;

/**
 * Service client for accessing AWS re:Post Private asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * AWS re:Post Private is a private version of AWS re:Post for enterprises with Enterprise Support or Enterprise On-Ramp
 * Support plans. It provides access to knowledge and experts to accelerate cloud adoption and increase developer
 * productivity. With your organization-specific private re:Post, you can build an organization-specific developer
 * community that drives efficiencies at scale and provides access to valuable knowledge resources. Additionally,
 * re:Post Private centralizes trusted AWS technical content and offers private discussion forums to improve how your
 * teams collaborate internally and with AWS to remove technical obstacles, accelerate innovation, and scale more
 * efficiently in the cloud.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface RepostspaceAsyncClient extends AwsClient {
    String SERVICE_NAME = "repostspace";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "repostspace";

    /**
     * <p>
     * Add role to multiple users or groups in a private re:Post channel.
     * </p>
     *
     * @param batchAddChannelRoleToAccessorsRequest
     * @return A Java Future containing the result of the BatchAddChannelRoleToAccessors operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.BatchAddChannelRoleToAccessors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/BatchAddChannelRoleToAccessors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAddChannelRoleToAccessorsResponse> batchAddChannelRoleToAccessors(
            BatchAddChannelRoleToAccessorsRequest batchAddChannelRoleToAccessorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add role to multiple users or groups in a private re:Post channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchAddChannelRoleToAccessorsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchAddChannelRoleToAccessorsRequest#builder()}
     * </p>
     *
     * @param batchAddChannelRoleToAccessorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.BatchAddChannelRoleToAccessorsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchAddChannelRoleToAccessors operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.BatchAddChannelRoleToAccessors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/BatchAddChannelRoleToAccessors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAddChannelRoleToAccessorsResponse> batchAddChannelRoleToAccessors(
            Consumer<BatchAddChannelRoleToAccessorsRequest.Builder> batchAddChannelRoleToAccessorsRequest) {
        return batchAddChannelRoleToAccessors(BatchAddChannelRoleToAccessorsRequest.builder()
                .applyMutation(batchAddChannelRoleToAccessorsRequest).build());
    }

    /**
     * <p>
     * Add a role to multiple users or groups in a private re:Post.
     * </p>
     *
     * @param batchAddRoleRequest
     * @return A Java Future containing the result of the BatchAddRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.BatchAddRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/BatchAddRole" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchAddRoleResponse> batchAddRole(BatchAddRoleRequest batchAddRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add a role to multiple users or groups in a private re:Post.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchAddRoleRequest.Builder} avoiding the need to
     * create one manually via {@link BatchAddRoleRequest#builder()}
     * </p>
     *
     * @param batchAddRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.BatchAddRoleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchAddRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.BatchAddRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/BatchAddRole" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchAddRoleResponse> batchAddRole(Consumer<BatchAddRoleRequest.Builder> batchAddRoleRequest) {
        return batchAddRole(BatchAddRoleRequest.builder().applyMutation(batchAddRoleRequest).build());
    }

    /**
     * <p>
     * Remove a role from multiple users or groups in a private re:Post channel.
     * </p>
     *
     * @param batchRemoveChannelRoleFromAccessorsRequest
     * @return A Java Future containing the result of the BatchRemoveChannelRoleFromAccessors operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.BatchRemoveChannelRoleFromAccessors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/BatchRemoveChannelRoleFromAccessors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchRemoveChannelRoleFromAccessorsResponse> batchRemoveChannelRoleFromAccessors(
            BatchRemoveChannelRoleFromAccessorsRequest batchRemoveChannelRoleFromAccessorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a role from multiple users or groups in a private re:Post channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchRemoveChannelRoleFromAccessorsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchRemoveChannelRoleFromAccessorsRequest#builder()}
     * </p>
     *
     * @param batchRemoveChannelRoleFromAccessorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.BatchRemoveChannelRoleFromAccessorsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchRemoveChannelRoleFromAccessors operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.BatchRemoveChannelRoleFromAccessors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/BatchRemoveChannelRoleFromAccessors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchRemoveChannelRoleFromAccessorsResponse> batchRemoveChannelRoleFromAccessors(
            Consumer<BatchRemoveChannelRoleFromAccessorsRequest.Builder> batchRemoveChannelRoleFromAccessorsRequest) {
        return batchRemoveChannelRoleFromAccessors(BatchRemoveChannelRoleFromAccessorsRequest.builder()
                .applyMutation(batchRemoveChannelRoleFromAccessorsRequest).build());
    }

    /**
     * <p>
     * Remove a role from multiple users or groups in a private re:Post.
     * </p>
     *
     * @param batchRemoveRoleRequest
     * @return A Java Future containing the result of the BatchRemoveRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.BatchRemoveRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/BatchRemoveRole" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchRemoveRoleResponse> batchRemoveRole(BatchRemoveRoleRequest batchRemoveRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a role from multiple users or groups in a private re:Post.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchRemoveRoleRequest.Builder} avoiding the need
     * to create one manually via {@link BatchRemoveRoleRequest#builder()}
     * </p>
     *
     * @param batchRemoveRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.BatchRemoveRoleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchRemoveRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.BatchRemoveRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/BatchRemoveRole" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchRemoveRoleResponse> batchRemoveRole(
            Consumer<BatchRemoveRoleRequest.Builder> batchRemoveRoleRequest) {
        return batchRemoveRole(BatchRemoveRoleRequest.builder().applyMutation(batchRemoveRoleRequest).build());
    }

    /**
     * <p>
     * Creates a channel in an AWS re:Post Private private re:Post.
     * </p>
     *
     * @param createChannelRequest
     * @return A Java Future containing the result of the CreateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateChannelResponse> createChannel(CreateChannelRequest createChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a channel in an AWS re:Post Private private re:Post.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateChannelRequest#builder()}
     * </p>
     *
     * @param createChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.CreateChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateChannelResponse> createChannel(Consumer<CreateChannelRequest.Builder> createChannelRequest) {
        return createChannel(CreateChannelRequest.builder().applyMutation(createChannelRequest).build());
    }

    /**
     * <p>
     * Creates an AWS re:Post Private private re:Post.
     * </p>
     *
     * @param createSpaceRequest
     * @return A Java Future containing the result of the CreateSpace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.CreateSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/CreateSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSpaceResponse> createSpace(CreateSpaceRequest createSpaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS re:Post Private private re:Post.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSpaceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSpaceRequest#builder()}
     * </p>
     *
     * @param createSpaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.CreateSpaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSpace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.CreateSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/CreateSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSpaceResponse> createSpace(Consumer<CreateSpaceRequest.Builder> createSpaceRequest) {
        return createSpace(CreateSpaceRequest.builder().applyMutation(createSpaceRequest).build());
    }

    /**
     * <p>
     * Deletes an AWS re:Post Private private re:Post.
     * </p>
     *
     * @param deleteSpaceRequest
     * @return A Java Future containing the result of the DeleteSpace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.DeleteSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/DeleteSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSpaceResponse> deleteSpace(DeleteSpaceRequest deleteSpaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an AWS re:Post Private private re:Post.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSpaceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSpaceRequest#builder()}
     * </p>
     *
     * @param deleteSpaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.DeleteSpaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSpace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.DeleteSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/DeleteSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSpaceResponse> deleteSpace(Consumer<DeleteSpaceRequest.Builder> deleteSpaceRequest) {
        return deleteSpace(DeleteSpaceRequest.builder().applyMutation(deleteSpaceRequest).build());
    }

    /**
     * <p>
     * Removes the user or group from the list of administrators of the private re:Post.
     * </p>
     *
     * @param deregisterAdminRequest
     * @return A Java Future containing the result of the DeregisterAdmin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.DeregisterAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/DeregisterAdmin" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterAdminResponse> deregisterAdmin(DeregisterAdminRequest deregisterAdminRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the user or group from the list of administrators of the private re:Post.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterAdminRequest.Builder} avoiding the need
     * to create one manually via {@link DeregisterAdminRequest#builder()}
     * </p>
     *
     * @param deregisterAdminRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.DeregisterAdminRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterAdmin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.DeregisterAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/DeregisterAdmin" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterAdminResponse> deregisterAdmin(
            Consumer<DeregisterAdminRequest.Builder> deregisterAdminRequest) {
        return deregisterAdmin(DeregisterAdminRequest.builder().applyMutation(deregisterAdminRequest).build());
    }

    /**
     * <p>
     * Displays information about a channel in a private re:Post.
     * </p>
     *
     * @param getChannelRequest
     * @return A Java Future containing the result of the GetChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.GetChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/GetChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetChannelResponse> getChannel(GetChannelRequest getChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays information about a channel in a private re:Post.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelRequest.Builder} avoiding the need to
     * create one manually via {@link GetChannelRequest#builder()}
     * </p>
     *
     * @param getChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.GetChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.GetChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/GetChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetChannelResponse> getChannel(Consumer<GetChannelRequest.Builder> getChannelRequest) {
        return getChannel(GetChannelRequest.builder().applyMutation(getChannelRequest).build());
    }

    /**
     * <p>
     * Displays information about the AWS re:Post Private private re:Post.
     * </p>
     *
     * @param getSpaceRequest
     * @return A Java Future containing the result of the GetSpace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.GetSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/GetSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSpaceResponse> getSpace(GetSpaceRequest getSpaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays information about the AWS re:Post Private private re:Post.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSpaceRequest.Builder} avoiding the need to
     * create one manually via {@link GetSpaceRequest#builder()}
     * </p>
     *
     * @param getSpaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.GetSpaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSpace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.GetSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/GetSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSpaceResponse> getSpace(Consumer<GetSpaceRequest.Builder> getSpaceRequest) {
        return getSpace(GetSpaceRequest.builder().applyMutation(getSpaceRequest).build());
    }

    /**
     * <p>
     * Returns the list of channel within a private re:Post with some information about each channel.
     * </p>
     *
     * @param listChannelsRequest
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels(ListChannelsRequest listChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of channel within a private re:Post with some information about each channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.ListChannelsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels(Consumer<ListChannelsRequest.Builder> listChannelsRequest) {
        return listChannels(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.repostspace.model.ListChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.repostspace.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.repostspace.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.repostspace.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.repostspace.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.repostspace.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @param listChannelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator(ListChannelsRequest listChannelsRequest) {
        return new ListChannelsPublisher(this, listChannelsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.repostspace.model.ListChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.repostspace.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.repostspace.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.repostspace.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.repostspace.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.repostspace.model.ListChannelsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.ListChannelsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator(Consumer<ListChannelsRequest.Builder> listChannelsRequest) {
        return listChannelsPaginator(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of AWS re:Post Private private re:Posts in the account with some information about each private
     * re:Post.
     * </p>
     *
     * @param listSpacesRequest
     * @return A Java Future containing the result of the ListSpaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.ListSpaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/ListSpaces" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSpacesResponse> listSpaces(ListSpacesRequest listSpacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of AWS re:Post Private private re:Posts in the account with some information about each private
     * re:Post.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSpacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSpacesRequest#builder()}
     * </p>
     *
     * @param listSpacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.ListSpacesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSpaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.ListSpaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/ListSpaces" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSpacesResponse> listSpaces(Consumer<ListSpacesRequest.Builder> listSpacesRequest) {
        return listSpaces(ListSpacesRequest.builder().applyMutation(listSpacesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listSpaces(software.amazon.awssdk.services.repostspace.model.ListSpacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.repostspace.paginators.ListSpacesPublisher publisher = client.listSpacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.repostspace.paginators.ListSpacesPublisher publisher = client.listSpacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.repostspace.model.ListSpacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.repostspace.model.ListSpacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSpaces(software.amazon.awssdk.services.repostspace.model.ListSpacesRequest)} operation.</b>
     * </p>
     *
     * @param listSpacesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.ListSpaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/ListSpaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSpacesPublisher listSpacesPaginator(ListSpacesRequest listSpacesRequest) {
        return new ListSpacesPublisher(this, listSpacesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listSpaces(software.amazon.awssdk.services.repostspace.model.ListSpacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.repostspace.paginators.ListSpacesPublisher publisher = client.listSpacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.repostspace.paginators.ListSpacesPublisher publisher = client.listSpacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.repostspace.model.ListSpacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.repostspace.model.ListSpacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSpaces(software.amazon.awssdk.services.repostspace.model.ListSpacesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSpacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSpacesRequest#builder()}
     * </p>
     *
     * @param listSpacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.ListSpacesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.ListSpaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/ListSpaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSpacesPublisher listSpacesPaginator(Consumer<ListSpacesRequest.Builder> listSpacesRequest) {
        return listSpacesPaginator(ListSpacesRequest.builder().applyMutation(listSpacesRequest).build());
    }

    /**
     * <p>
     * Returns the tags that are associated with the AWS re:Post Private resource specified by the resourceArn. The only
     * resource that can be tagged is a private re:Post.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the tags that are associated with the AWS re:Post Private resource specified by the resourceArn. The only
     * resource that can be tagged is a private re:Post.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds a user or group to the list of administrators of the private re:Post.
     * </p>
     *
     * @param registerAdminRequest
     * @return A Java Future containing the result of the RegisterAdmin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.RegisterAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/RegisterAdmin" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RegisterAdminResponse> registerAdmin(RegisterAdminRequest registerAdminRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a user or group to the list of administrators of the private re:Post.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterAdminRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterAdminRequest#builder()}
     * </p>
     *
     * @param registerAdminRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.RegisterAdminRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegisterAdmin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.RegisterAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/RegisterAdmin" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RegisterAdminResponse> registerAdmin(Consumer<RegisterAdminRequest.Builder> registerAdminRequest) {
        return registerAdmin(RegisterAdminRequest.builder().applyMutation(registerAdminRequest).build());
    }

    /**
     * <p>
     * Sends an invitation email to selected users and groups.
     * </p>
     *
     * @param sendInvitesRequest
     * @return A Java Future containing the result of the SendInvites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.SendInvites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/SendInvites" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendInvitesResponse> sendInvites(SendInvitesRequest sendInvitesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends an invitation email to selected users and groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendInvitesRequest.Builder} avoiding the need to
     * create one manually via {@link SendInvitesRequest#builder()}
     * </p>
     *
     * @param sendInvitesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.SendInvitesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SendInvites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.SendInvites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/SendInvites" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendInvitesResponse> sendInvites(Consumer<SendInvitesRequest.Builder> sendInvitesRequest) {
        return sendInvites(SendInvitesRequest.builder().applyMutation(sendInvitesRequest).build());
    }

    /**
     * <p>
     * Associates tags with an AWS re:Post Private resource. Currently, the only resource that can be tagged is the
     * private re:Post. If you specify a new tag key for the resource, the tag is appended to the list of tags that are
     * associated with the resource. If you specify a tag key that’s already associated with the resource, the new tag
     * value that you specify replaces the previous value for that tag.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates tags with an AWS re:Post Private resource. Currently, the only resource that can be tagged is the
     * private re:Post. If you specify a new tag key for the resource, the tag is appended to the list of tags that are
     * associated with the resource. If you specify a tag key that’s already associated with the resource, the new tag
     * value that you specify replaces the previous value for that tag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the association of the tag with the AWS re:Post Private resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association of the tag with the AWS re:Post Private resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Modifies an existing channel.
     * </p>
     *
     * @param updateChannelRequest
     * @return A Java Future containing the result of the UpdateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateChannelResponse> updateChannel(UpdateChannelRequest updateChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateChannelRequest#builder()}
     * </p>
     *
     * @param updateChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.UpdateChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateChannelResponse> updateChannel(Consumer<UpdateChannelRequest.Builder> updateChannelRequest) {
        return updateChannel(UpdateChannelRequest.builder().applyMutation(updateChannelRequest).build());
    }

    /**
     * <p>
     * Modifies an existing AWS re:Post Private private re:Post.
     * </p>
     *
     * @param updateSpaceRequest
     * @return A Java Future containing the result of the UpdateSpace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.UpdateSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/UpdateSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSpaceResponse> updateSpace(UpdateSpaceRequest updateSpaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing AWS re:Post Private private re:Post.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSpaceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSpaceRequest#builder()}
     * </p>
     *
     * @param updateSpaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.repostspace.model.UpdateSpaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSpace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RepostspaceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RepostspaceAsyncClient.UpdateSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/UpdateSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSpaceResponse> updateSpace(Consumer<UpdateSpaceRequest.Builder> updateSpaceRequest) {
        return updateSpace(UpdateSpaceRequest.builder().applyMutation(updateSpaceRequest).build());
    }

    /**
     * Create an instance of {@link RepostspaceAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link RepostspaceAsyncWaiter}
     */
    default RepostspaceAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default RepostspaceServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link RepostspaceAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RepostspaceAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RepostspaceAsyncClient}.
     */
    static RepostspaceAsyncClientBuilder builder() {
        return new DefaultRepostspaceAsyncClientBuilder();
    }
}
