/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.repostspace.RepostspaceClient;
import software.amazon.awssdk.services.repostspace.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.repostspace.model.GetChannelRequest;
import software.amazon.awssdk.services.repostspace.model.GetChannelResponse;
import software.amazon.awssdk.services.repostspace.model.GetSpaceRequest;
import software.amazon.awssdk.services.repostspace.model.GetSpaceResponse;
import software.amazon.awssdk.services.repostspace.model.RepostspaceRequest;
import software.amazon.awssdk.services.repostspace.waiters.RepostspaceWaiter;
import software.amazon.awssdk.services.repostspace.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultRepostspaceWaiter
implements RepostspaceWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final RepostspaceClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetChannelResponse> channelCreatedWaiter;
    private final Waiter<GetChannelResponse> channelDeletedWaiter;
    private final Waiter<GetSpaceResponse> spaceCreatedWaiter;
    private final Waiter<GetSpaceResponse> spaceDeletedWaiter;

    private DefaultRepostspaceWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (RepostspaceClient)RepostspaceClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.channelCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetChannelResponse.class).acceptors(DefaultRepostspaceWaiter.channelCreatedWaiterAcceptors())).overrideConfiguration(DefaultRepostspaceWaiter.channelCreatedWaiterConfig(builder.overrideConfiguration))).build();
        this.channelDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetChannelResponse.class).acceptors(DefaultRepostspaceWaiter.channelDeletedWaiterAcceptors())).overrideConfiguration(DefaultRepostspaceWaiter.channelDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.spaceCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetSpaceResponse.class).acceptors(DefaultRepostspaceWaiter.spaceCreatedWaiterAcceptors())).overrideConfiguration(DefaultRepostspaceWaiter.spaceCreatedWaiterConfig(builder.overrideConfiguration))).build();
        this.spaceDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetSpaceResponse.class).acceptors(DefaultRepostspaceWaiter.spaceDeletedWaiterAcceptors())).overrideConfiguration(DefaultRepostspaceWaiter.spaceDeletedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetChannelResponse> waitUntilChannelCreated(GetChannelRequest getChannelRequest) {
        return this.channelCreatedWaiter.run(() -> this.client.getChannel(this.applyWaitersUserAgent(getChannelRequest)));
    }

    @Override
    public WaiterResponse<GetChannelResponse> waitUntilChannelCreated(GetChannelRequest getChannelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.channelCreatedWaiter.run(() -> this.client.getChannel(this.applyWaitersUserAgent(getChannelRequest)), DefaultRepostspaceWaiter.channelCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetChannelResponse> waitUntilChannelDeleted(GetChannelRequest getChannelRequest) {
        return this.channelDeletedWaiter.run(() -> this.client.getChannel(this.applyWaitersUserAgent(getChannelRequest)));
    }

    @Override
    public WaiterResponse<GetChannelResponse> waitUntilChannelDeleted(GetChannelRequest getChannelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.channelDeletedWaiter.run(() -> this.client.getChannel(this.applyWaitersUserAgent(getChannelRequest)), DefaultRepostspaceWaiter.channelDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetSpaceResponse> waitUntilSpaceCreated(GetSpaceRequest getSpaceRequest) {
        return this.spaceCreatedWaiter.run(() -> this.client.getSpace(this.applyWaitersUserAgent(getSpaceRequest)));
    }

    @Override
    public WaiterResponse<GetSpaceResponse> waitUntilSpaceCreated(GetSpaceRequest getSpaceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.spaceCreatedWaiter.run(() -> this.client.getSpace(this.applyWaitersUserAgent(getSpaceRequest)), DefaultRepostspaceWaiter.spaceCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetSpaceResponse> waitUntilSpaceDeleted(GetSpaceRequest getSpaceRequest) {
        return this.spaceDeletedWaiter.run(() -> this.client.getSpace(this.applyWaitersUserAgent(getSpaceRequest)));
    }

    @Override
    public WaiterResponse<GetSpaceResponse> waitUntilSpaceDeleted(GetSpaceRequest getSpaceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.spaceDeletedWaiter.run(() -> this.client.getSpace(this.applyWaitersUserAgent(getSpaceRequest)), DefaultRepostspaceWaiter.spaceDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetChannelResponse>> channelCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetChannelResponse>> result = new ArrayList<WaiterAcceptor<? super GetChannelResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("channelStatus").value(), "CREATED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("channelStatus").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (channelStatus=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("channelStatus").value(), "CREATING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetChannelResponse>> channelDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetChannelResponse>> result = new ArrayList<WaiterAcceptor<? super GetChannelResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultRepostspaceWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("channelStatus").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("channelStatus").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (channelStatus=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("channelStatus").value(), "DELETING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetSpaceResponse>> spaceCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetSpaceResponse>> result = new ArrayList<WaiterAcceptor<? super GetSpaceResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetSpaceResponse>> spaceDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetSpaceResponse>> result = new ArrayList<WaiterAcceptor<? super GetSpaceResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultRepostspaceWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration channelCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration channelDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration spaceCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(24);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(300L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration spaceDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(24);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(300L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static RepostspaceWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends RepostspaceRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RepostspaceRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements RepostspaceWaiter.Builder {
        private RepostspaceClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public RepostspaceWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public RepostspaceWaiter.Builder client(RepostspaceClient client) {
            this.client = client;
            return this;
        }

        @Override
        public RepostspaceWaiter build() {
            return new DefaultRepostspaceWaiter(this);
        }
    }
}

