/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.repostspace.model.RepostspaceRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteSpaceRequest
extends RepostspaceRequest
implements ToCopyableBuilder<Builder, DeleteSpaceRequest> {
    private static final SdkField<String> SPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceId").getter(DeleteSpaceRequest.getter(DeleteSpaceRequest::spaceId)).setter(DeleteSpaceRequest.setter(Builder::spaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("spaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_ID_FIELD));
    private final String spaceId;

    private DeleteSpaceRequest(BuilderImpl builder) {
        super(builder);
        this.spaceId = builder.spaceId;
    }

    public final String spaceId() {
        return this.spaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSpaceRequest)) {
            return false;
        }
        DeleteSpaceRequest other = (DeleteSpaceRequest)((Object)obj);
        return Objects.equals(this.spaceId(), other.spaceId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteSpaceRequest").add("SpaceId", (Object)this.spaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spaceId": {
                return Optional.ofNullable(clazz.cast(this.spaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteSpaceRequest, T> g) {
        return obj -> g.apply((DeleteSpaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RepostspaceRequest.BuilderImpl
    implements Builder {
        private String spaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSpaceRequest model) {
            super(model);
            this.spaceId(model.spaceId);
        }

        public final String getSpaceId() {
            return this.spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSpaceRequest build() {
            return new DeleteSpaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RepostspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteSpaceRequest> {
        public Builder spaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

