/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.release;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import software.amazon.awssdk.release.Cli;
import software.amazon.awssdk.release.PomTransformer;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.internal.CodegenNamingUtils;

public class CreateNewServiceModuleMain
extends Cli {
    private static final Set<String> DEFAULT_INTERNAL_DEPENDENCIES = CreateNewServiceModuleMain.toSet("http-auth-aws");

    private CreateNewServiceModuleMain() {
        super(CreateNewServiceModuleMain.requiredOption("service-module-name", "The name of the service module to be created."), CreateNewServiceModuleMain.requiredOption("service-id", "The service ID of the service module to be created."), CreateNewServiceModuleMain.requiredOption("service-protocol", "The protocol of the service module to be created."), CreateNewServiceModuleMain.requiredOption("maven-project-root", "The root directory for the maven project."), CreateNewServiceModuleMain.requiredOption("maven-project-version", "The maven version of the service module to be created."), CreateNewServiceModuleMain.optionalMultiValueOption("include-internal-dependency", "Includes an internal dependency from new service pom."), CreateNewServiceModuleMain.optionalMultiValueOption("exclude-internal-dependency", "Excludes an internal dependency from new service pom."));
    }

    public static void main(String[] args) {
        new CreateNewServiceModuleMain().run(args);
    }

    static Set<String> toSet(String ... args) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String arg : args) {
            result.add(arg);
        }
        return Collections.unmodifiableSet(result);
    }

    static List<String> toList(String[] optionValues) {
        if (optionValues == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(optionValues);
    }

    static Set<String> computeInternalDependencies(List<String> includes, List<String> excludes) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(DEFAULT_INTERNAL_DEPENDENCIES);
        result.addAll(includes);
        excludes.forEach(result::remove);
        return Collections.unmodifiableSet(result);
    }

    @Override
    protected void run(CommandLine commandLine) throws Exception {
        new NewServiceCreator(commandLine).run();
    }

    static class AddInternalDependenciesTransformer
    extends PomTransformer {
        private final Set<String> internalDependencies;

        AddInternalDependenciesTransformer(Set<String> internalDependencies) {
            this.internalDependencies = internalDependencies;
        }

        @Override
        protected void updateDocument(Document doc) {
            Node project = this.findChild(doc, "project");
            Node dependencies = this.findChild(project, "dependencies");
            for (String internalDependency : this.internalDependencies) {
                dependencies.appendChild(this.sdkDependencyElement(doc, internalDependency));
            }
        }
    }

    private static class NewServiceCreator {
        private final Path mavenProjectRoot;
        private final String mavenProjectVersion;
        private final String serviceModuleName;
        private final String serviceId;
        private final String serviceProtocol;
        private final Set<String> internalDependencies;

        private NewServiceCreator(CommandLine commandLine) {
            this.mavenProjectRoot = Paths.get(commandLine.getOptionValue("maven-project-root").trim(), new String[0]);
            this.mavenProjectVersion = commandLine.getOptionValue("maven-project-version").trim();
            this.serviceModuleName = commandLine.getOptionValue("service-module-name").trim();
            this.serviceId = commandLine.getOptionValue("service-id").trim();
            this.serviceProtocol = this.transformSpecialProtocols(commandLine.getOptionValue("service-protocol").trim());
            this.internalDependencies = CreateNewServiceModuleMain.computeInternalDependencies(CreateNewServiceModuleMain.toList(commandLine.getOptionValues("include-internal-dependency")), CreateNewServiceModuleMain.toList(commandLine.getOptionValues("exclude-internal-dependency")));
            Validate.isTrue((boolean)Files.exists(this.mavenProjectRoot, new LinkOption[0]), (String)("Project root does not exist: " + this.mavenProjectRoot), (Object[])new Object[0]);
        }

        private String transformSpecialProtocols(String protocol) {
            switch (protocol) {
                case "ec2": {
                    return "query";
                }
                case "rest-xml": {
                    return "xml";
                }
                case "rest-json": {
                    return "json";
                }
            }
            return protocol;
        }

        public void run() throws Exception {
            Path servicesRoot = this.mavenProjectRoot.resolve("services");
            Path templateModulePath = servicesRoot.resolve("new-service-template");
            Path newServiceModulePath = servicesRoot.resolve(this.serviceModuleName);
            this.createNewModuleFromTemplate(templateModulePath, newServiceModulePath);
            this.replaceTemplatePlaceholders(newServiceModulePath);
            Path newServicePom = newServiceModulePath.resolve("pom.xml");
            new AddInternalDependenciesTransformer(this.internalDependencies).transform(newServicePom);
        }

        private void createNewModuleFromTemplate(Path templateModulePath, Path newServiceModule) throws IOException {
            FileUtils.copyDirectory((File)templateModulePath.toFile(), (File)newServiceModule.toFile());
        }

        private void replaceTemplatePlaceholders(Path newServiceModule) throws IOException {
            Files.walkFileTree(newServiceModule, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    this.replacePlaceholdersInFile(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        private void replacePlaceholdersInFile(Path file) throws IOException {
            String fileContents = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
            String newFileContents = this.replacePlaceholders(fileContents);
            Files.write(file, newFileContents.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }

        private String replacePlaceholders(String line) {
            String[] searchList = new String[]{"{{MVN_ARTIFACT_ID}}", "{{MVN_NAME}}", "{{MVN_VERSION}}", "{{PROTOCOL}}"};
            String[] replaceList = new String[]{this.serviceModuleName, this.mavenName(this.serviceId), this.mavenProjectVersion, this.serviceProtocol};
            return StringUtils.replaceEach((String)line, (String[])searchList, (String[])replaceList);
        }

        private String mavenName(String serviceId) {
            return Stream.of(CodegenNamingUtils.splitOnWordBoundaries((String)serviceId)).map(StringUtils::capitalize).collect(Collectors.joining(" "));
        }
    }
}

