/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.CollectionIdListCopier;
import software.amazon.awssdk.services.rekognition.model.FaceModelVersionListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCollectionsResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, ListCollectionsResponse> {
    private static final SdkField<List<String>> COLLECTION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListCollectionsResponse.getter(ListCollectionsResponse::collectionIds)).setter(ListCollectionsResponse.setter(Builder::collectionIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListCollectionsResponse.getter(ListCollectionsResponse::nextToken)).setter(ListCollectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<String>> FACE_MODEL_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListCollectionsResponse.getter(ListCollectionsResponse::faceModelVersions)).setter(ListCollectionsResponse.setter(Builder::faceModelVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceModelVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_IDS_FIELD, NEXT_TOKEN_FIELD, FACE_MODEL_VERSIONS_FIELD));
    private final List<String> collectionIds;
    private final String nextToken;
    private final List<String> faceModelVersions;

    private ListCollectionsResponse(BuilderImpl builder) {
        super(builder);
        this.collectionIds = builder.collectionIds;
        this.nextToken = builder.nextToken;
        this.faceModelVersions = builder.faceModelVersions;
    }

    public List<String> collectionIds() {
        return this.collectionIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> faceModelVersions() {
        return this.faceModelVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceModelVersions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollectionsResponse)) {
            return false;
        }
        ListCollectionsResponse other = (ListCollectionsResponse)((Object)obj);
        return Objects.equals(this.collectionIds(), other.collectionIds()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.faceModelVersions(), other.faceModelVersions());
    }

    public String toString() {
        return ToString.builder((String)"ListCollectionsResponse").add("CollectionIds", this.collectionIds()).add("NextToken", (Object)this.nextToken()).add("FaceModelVersions", this.faceModelVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionIds": {
                return Optional.ofNullable(clazz.cast(this.collectionIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "FaceModelVersions": {
                return Optional.ofNullable(clazz.cast(this.faceModelVersions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCollectionsResponse, T> g) {
        return obj -> g.apply((ListCollectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<String> collectionIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private List<String> faceModelVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollectionsResponse model) {
            super(model);
            this.collectionIds(model.collectionIds);
            this.nextToken(model.nextToken);
            this.faceModelVersions(model.faceModelVersions);
        }

        public final Collection<String> getCollectionIds() {
            return this.collectionIds;
        }

        @Override
        public final Builder collectionIds(Collection<String> collectionIds) {
            this.collectionIds = CollectionIdListCopier.copy(collectionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionIds(String ... collectionIds) {
            this.collectionIds(Arrays.asList(collectionIds));
            return this;
        }

        public final void setCollectionIds(Collection<String> collectionIds) {
            this.collectionIds = CollectionIdListCopier.copy(collectionIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getFaceModelVersions() {
            return this.faceModelVersions;
        }

        @Override
        public final Builder faceModelVersions(Collection<String> faceModelVersions) {
            this.faceModelVersions = FaceModelVersionListCopier.copy(faceModelVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceModelVersions(String ... faceModelVersions) {
            this.faceModelVersions(Arrays.asList(faceModelVersions));
            return this;
        }

        public final void setFaceModelVersions(Collection<String> faceModelVersions) {
            this.faceModelVersions = FaceModelVersionListCopier.copy(faceModelVersions);
        }

        @Override
        public ListCollectionsResponse build() {
            return new ListCollectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCollectionsResponse> {
        public Builder collectionIds(Collection<String> var1);

        public Builder collectionIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder faceModelVersions(Collection<String> var1);

        public Builder faceModelVersions(String ... var1);
    }
}

