/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.CollectionIdListCopier;
import software.amazon.awssdk.services.rekognition.model.FaceModelVersionListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCollectionsResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, ListCollectionsResponse> {
    private static final SdkField<List<String>> COLLECTION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CollectionIds").getter(ListCollectionsResponse.getter(ListCollectionsResponse::collectionIds)).setter(ListCollectionsResponse.setter(Builder::collectionIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCollectionsResponse.getter(ListCollectionsResponse::nextToken)).setter(ListCollectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<String>> FACE_MODEL_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FaceModelVersions").getter(ListCollectionsResponse.getter(ListCollectionsResponse::faceModelVersions)).setter(ListCollectionsResponse.setter(Builder::faceModelVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceModelVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_IDS_FIELD, NEXT_TOKEN_FIELD, FACE_MODEL_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCollectionsResponse.memberNameToFieldInitializer();
    private final List<String> collectionIds;
    private final String nextToken;
    private final List<String> faceModelVersions;

    private ListCollectionsResponse(BuilderImpl builder) {
        super(builder);
        this.collectionIds = builder.collectionIds;
        this.nextToken = builder.nextToken;
        this.faceModelVersions = builder.faceModelVersions;
    }

    public final boolean hasCollectionIds() {
        return this.collectionIds != null && !(this.collectionIds instanceof SdkAutoConstructList);
    }

    public final List<String> collectionIds() {
        return this.collectionIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFaceModelVersions() {
        return this.faceModelVersions != null && !(this.faceModelVersions instanceof SdkAutoConstructList);
    }

    public final List<String> faceModelVersions() {
        return this.faceModelVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollectionIds() ? this.collectionIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFaceModelVersions() ? this.faceModelVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollectionsResponse)) {
            return false;
        }
        ListCollectionsResponse other = (ListCollectionsResponse)((Object)obj);
        return this.hasCollectionIds() == other.hasCollectionIds() && Objects.equals(this.collectionIds(), other.collectionIds()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasFaceModelVersions() == other.hasFaceModelVersions() && Objects.equals(this.faceModelVersions(), other.faceModelVersions());
    }

    public final String toString() {
        return ToString.builder((String)"ListCollectionsResponse").add("CollectionIds", this.hasCollectionIds() ? this.collectionIds() : null).add("NextToken", (Object)this.nextToken()).add("FaceModelVersions", this.hasFaceModelVersions() ? this.faceModelVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionIds": {
                return Optional.ofNullable(clazz.cast(this.collectionIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "FaceModelVersions": {
                return Optional.ofNullable(clazz.cast(this.faceModelVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CollectionIds", COLLECTION_IDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("FaceModelVersions", FACE_MODEL_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCollectionsResponse, T> g) {
        return obj -> g.apply((ListCollectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<String> collectionIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private List<String> faceModelVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollectionsResponse model) {
            super(model);
            this.collectionIds(model.collectionIds);
            this.nextToken(model.nextToken);
            this.faceModelVersions(model.faceModelVersions);
        }

        public final Collection<String> getCollectionIds() {
            if (this.collectionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.collectionIds;
        }

        public final void setCollectionIds(Collection<String> collectionIds) {
            this.collectionIds = CollectionIdListCopier.copy(collectionIds);
        }

        @Override
        public final Builder collectionIds(Collection<String> collectionIds) {
            this.collectionIds = CollectionIdListCopier.copy(collectionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionIds(String ... collectionIds) {
            this.collectionIds(Arrays.asList(collectionIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getFaceModelVersions() {
            if (this.faceModelVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.faceModelVersions;
        }

        public final void setFaceModelVersions(Collection<String> faceModelVersions) {
            this.faceModelVersions = FaceModelVersionListCopier.copy(faceModelVersions);
        }

        @Override
        public final Builder faceModelVersions(Collection<String> faceModelVersions) {
            this.faceModelVersions = FaceModelVersionListCopier.copy(faceModelVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceModelVersions(String ... faceModelVersions) {
            this.faceModelVersions(Arrays.asList(faceModelVersions));
            return this;
        }

        @Override
        public ListCollectionsResponse build() {
            return new ListCollectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCollectionsResponse> {
        public Builder collectionIds(Collection<String> var1);

        public Builder collectionIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder faceModelVersions(Collection<String> var1);

        public Builder faceModelVersions(String ... var1);
    }
}

