/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.DistributeDataset;
import software.amazon.awssdk.services.rekognition.model.DistributeDatasetMetadataListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DistributeDatasetEntriesRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, DistributeDatasetEntriesRequest> {
    private static final SdkField<List<DistributeDataset>> DATASETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Datasets").getter(DistributeDatasetEntriesRequest.getter(DistributeDatasetEntriesRequest::datasets)).setter(DistributeDatasetEntriesRequest.setter(Builder::datasets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datasets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DistributeDataset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DistributeDatasetEntriesRequest.memberNameToFieldInitializer();
    private final List<DistributeDataset> datasets;

    private DistributeDatasetEntriesRequest(BuilderImpl builder) {
        super(builder);
        this.datasets = builder.datasets;
    }

    public final boolean hasDatasets() {
        return this.datasets != null && !(this.datasets instanceof SdkAutoConstructList);
    }

    public final List<DistributeDataset> datasets() {
        return this.datasets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasets() ? this.datasets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributeDatasetEntriesRequest)) {
            return false;
        }
        DistributeDatasetEntriesRequest other = (DistributeDatasetEntriesRequest)((Object)obj);
        return this.hasDatasets() == other.hasDatasets() && Objects.equals(this.datasets(), other.datasets());
    }

    public final String toString() {
        return ToString.builder((String)"DistributeDatasetEntriesRequest").add("Datasets", this.hasDatasets() ? this.datasets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Datasets": {
                return Optional.ofNullable(clazz.cast(this.datasets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<DistributeDataset>>> map = new HashMap<String, SdkField<List<DistributeDataset>>>();
        map.put("Datasets", DATASETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DistributeDatasetEntriesRequest, T> g) {
        return obj -> g.apply((DistributeDatasetEntriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private List<DistributeDataset> datasets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DistributeDatasetEntriesRequest model) {
            super(model);
            this.datasets(model.datasets);
        }

        public final List<DistributeDataset.Builder> getDatasets() {
            List<DistributeDataset.Builder> result = DistributeDatasetMetadataListCopier.copyToBuilder(this.datasets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasets(Collection<DistributeDataset.BuilderImpl> datasets) {
            this.datasets = DistributeDatasetMetadataListCopier.copyFromBuilder(datasets);
        }

        @Override
        public final Builder datasets(Collection<DistributeDataset> datasets) {
            this.datasets = DistributeDatasetMetadataListCopier.copy(datasets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(DistributeDataset ... datasets) {
            this.datasets(Arrays.asList(datasets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(Consumer<DistributeDataset.Builder> ... datasets) {
            this.datasets(Stream.of(datasets).map(c -> (DistributeDataset)((DistributeDataset.Builder)DistributeDataset.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DistributeDatasetEntriesRequest build() {
            return new DistributeDatasetEntriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DistributeDatasetEntriesRequest> {
        public Builder datasets(Collection<DistributeDataset> var1);

        public Builder datasets(DistributeDataset ... var1);

        public Builder datasets(Consumer<DistributeDataset.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

