/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.DatasetLabelDescription;
import software.amazon.awssdk.services.rekognition.model.DatasetLabelDescriptionsCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatasetLabelsResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, ListDatasetLabelsResponse> {
    private static final SdkField<List<DatasetLabelDescription>> DATASET_LABEL_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatasetLabelDescriptions").getter(ListDatasetLabelsResponse.getter(ListDatasetLabelsResponse::datasetLabelDescriptions)).setter(ListDatasetLabelsResponse.setter(Builder::datasetLabelDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetLabelDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetLabelDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDatasetLabelsResponse.getter(ListDatasetLabelsResponse::nextToken)).setter(ListDatasetLabelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_LABEL_DESCRIPTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDatasetLabelsResponse.memberNameToFieldInitializer();
    private final List<DatasetLabelDescription> datasetLabelDescriptions;
    private final String nextToken;

    private ListDatasetLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.datasetLabelDescriptions = builder.datasetLabelDescriptions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDatasetLabelDescriptions() {
        return this.datasetLabelDescriptions != null && !(this.datasetLabelDescriptions instanceof SdkAutoConstructList);
    }

    public final List<DatasetLabelDescription> datasetLabelDescriptions() {
        return this.datasetLabelDescriptions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasetLabelDescriptions() ? this.datasetLabelDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetLabelsResponse)) {
            return false;
        }
        ListDatasetLabelsResponse other = (ListDatasetLabelsResponse)((Object)obj);
        return this.hasDatasetLabelDescriptions() == other.hasDatasetLabelDescriptions() && Objects.equals(this.datasetLabelDescriptions(), other.datasetLabelDescriptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDatasetLabelsResponse").add("DatasetLabelDescriptions", this.hasDatasetLabelDescriptions() ? this.datasetLabelDescriptions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetLabelDescriptions": {
                return Optional.ofNullable(clazz.cast(this.datasetLabelDescriptions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DatasetLabelDescriptions", DATASET_LABEL_DESCRIPTIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetLabelsResponse, T> g) {
        return obj -> g.apply((ListDatasetLabelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<DatasetLabelDescription> datasetLabelDescriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetLabelsResponse model) {
            super(model);
            this.datasetLabelDescriptions(model.datasetLabelDescriptions);
            this.nextToken(model.nextToken);
        }

        public final List<DatasetLabelDescription.Builder> getDatasetLabelDescriptions() {
            List<DatasetLabelDescription.Builder> result = DatasetLabelDescriptionsCopier.copyToBuilder(this.datasetLabelDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasetLabelDescriptions(Collection<DatasetLabelDescription.BuilderImpl> datasetLabelDescriptions) {
            this.datasetLabelDescriptions = DatasetLabelDescriptionsCopier.copyFromBuilder(datasetLabelDescriptions);
        }

        @Override
        public final Builder datasetLabelDescriptions(Collection<DatasetLabelDescription> datasetLabelDescriptions) {
            this.datasetLabelDescriptions = DatasetLabelDescriptionsCopier.copy(datasetLabelDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetLabelDescriptions(DatasetLabelDescription ... datasetLabelDescriptions) {
            this.datasetLabelDescriptions(Arrays.asList(datasetLabelDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetLabelDescriptions(Consumer<DatasetLabelDescription.Builder> ... datasetLabelDescriptions) {
            this.datasetLabelDescriptions(Stream.of(datasetLabelDescriptions).map(c -> (DatasetLabelDescription)((DatasetLabelDescription.Builder)DatasetLabelDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDatasetLabelsResponse build() {
            return new ListDatasetLabelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatasetLabelsResponse> {
        public Builder datasetLabelDescriptions(Collection<DatasetLabelDescription> var1);

        public Builder datasetLabelDescriptions(DatasetLabelDescription ... var1);

        public Builder datasetLabelDescriptions(Consumer<DatasetLabelDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

