/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.MediaAnalysisInput;
import software.amazon.awssdk.services.rekognition.model.MediaAnalysisJobFailureDetails;
import software.amazon.awssdk.services.rekognition.model.MediaAnalysisJobStatus;
import software.amazon.awssdk.services.rekognition.model.MediaAnalysisManifestSummary;
import software.amazon.awssdk.services.rekognition.model.MediaAnalysisOperationsConfig;
import software.amazon.awssdk.services.rekognition.model.MediaAnalysisOutputConfig;
import software.amazon.awssdk.services.rekognition.model.MediaAnalysisResults;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMediaAnalysisJobResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, GetMediaAnalysisJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(GetMediaAnalysisJobResponse.getter(GetMediaAnalysisJobResponse::jobId)).setter(GetMediaAnalysisJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(GetMediaAnalysisJobResponse.getter(GetMediaAnalysisJobResponse::jobName)).setter(GetMediaAnalysisJobResponse.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<MediaAnalysisOperationsConfig> OPERATIONS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OperationsConfig").getter(GetMediaAnalysisJobResponse.getter(GetMediaAnalysisJobResponse::operationsConfig)).setter(GetMediaAnalysisJobResponse.setter(Builder::operationsConfig)).constructor(MediaAnalysisOperationsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationsConfig").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetMediaAnalysisJobResponse.getter(GetMediaAnalysisJobResponse::statusAsString)).setter(GetMediaAnalysisJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<MediaAnalysisJobFailureDetails> FAILURE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureDetails").getter(GetMediaAnalysisJobResponse.getter(GetMediaAnalysisJobResponse::failureDetails)).setter(GetMediaAnalysisJobResponse.setter(Builder::failureDetails)).constructor(MediaAnalysisJobFailureDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDetails").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimestamp").getter(GetMediaAnalysisJobResponse.getter(GetMediaAnalysisJobResponse::creationTimestamp)).setter(GetMediaAnalysisJobResponse.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTimestamp").getter(GetMediaAnalysisJobResponse.getter(GetMediaAnalysisJobResponse::completionTimestamp)).setter(GetMediaAnalysisJobResponse.setter(Builder::completionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTimestamp").build()}).build();
    private static final SdkField<MediaAnalysisInput> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Input").getter(GetMediaAnalysisJobResponse.getter(GetMediaAnalysisJobResponse::input)).setter(GetMediaAnalysisJobResponse.setter(Builder::input)).constructor(MediaAnalysisInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()}).build();
    private static final SdkField<MediaAnalysisOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(GetMediaAnalysisJobResponse.getter(GetMediaAnalysisJobResponse::outputConfig)).setter(GetMediaAnalysisJobResponse.setter(Builder::outputConfig)).constructor(MediaAnalysisOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(GetMediaAnalysisJobResponse.getter(GetMediaAnalysisJobResponse::kmsKeyId)).setter(GetMediaAnalysisJobResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<MediaAnalysisResults> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Results").getter(GetMediaAnalysisJobResponse.getter(GetMediaAnalysisJobResponse::results)).setter(GetMediaAnalysisJobResponse.setter(Builder::results)).constructor(MediaAnalysisResults::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build()}).build();
    private static final SdkField<MediaAnalysisManifestSummary> MANIFEST_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManifestSummary").getter(GetMediaAnalysisJobResponse.getter(GetMediaAnalysisJobResponse::manifestSummary)).setter(GetMediaAnalysisJobResponse.setter(Builder::manifestSummary)).constructor(MediaAnalysisManifestSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_NAME_FIELD, OPERATIONS_CONFIG_FIELD, STATUS_FIELD, FAILURE_DETAILS_FIELD, CREATION_TIMESTAMP_FIELD, COMPLETION_TIMESTAMP_FIELD, INPUT_FIELD, OUTPUT_CONFIG_FIELD, KMS_KEY_ID_FIELD, RESULTS_FIELD, MANIFEST_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMediaAnalysisJobResponse.memberNameToFieldInitializer();
    private final String jobId;
    private final String jobName;
    private final MediaAnalysisOperationsConfig operationsConfig;
    private final String status;
    private final MediaAnalysisJobFailureDetails failureDetails;
    private final Instant creationTimestamp;
    private final Instant completionTimestamp;
    private final MediaAnalysisInput input;
    private final MediaAnalysisOutputConfig outputConfig;
    private final String kmsKeyId;
    private final MediaAnalysisResults results;
    private final MediaAnalysisManifestSummary manifestSummary;

    private GetMediaAnalysisJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.operationsConfig = builder.operationsConfig;
        this.status = builder.status;
        this.failureDetails = builder.failureDetails;
        this.creationTimestamp = builder.creationTimestamp;
        this.completionTimestamp = builder.completionTimestamp;
        this.input = builder.input;
        this.outputConfig = builder.outputConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.results = builder.results;
        this.manifestSummary = builder.manifestSummary;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final MediaAnalysisOperationsConfig operationsConfig() {
        return this.operationsConfig;
    }

    public final MediaAnalysisJobStatus status() {
        return MediaAnalysisJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final MediaAnalysisJobFailureDetails failureDetails() {
        return this.failureDetails;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final Instant completionTimestamp() {
        return this.completionTimestamp;
    }

    public final MediaAnalysisInput input() {
        return this.input;
    }

    public final MediaAnalysisOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final MediaAnalysisResults results() {
        return this.results;
    }

    public final MediaAnalysisManifestSummary manifestSummary() {
        return this.manifestSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.results());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMediaAnalysisJobResponse)) {
            return false;
        }
        GetMediaAnalysisJobResponse other = (GetMediaAnalysisJobResponse)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.operationsConfig(), other.operationsConfig()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureDetails(), other.failureDetails()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.completionTimestamp(), other.completionTimestamp()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.results(), other.results()) && Objects.equals(this.manifestSummary(), other.manifestSummary());
    }

    public final String toString() {
        return ToString.builder((String)"GetMediaAnalysisJobResponse").add("JobId", (Object)this.jobId()).add("JobName", (Object)this.jobName()).add("OperationsConfig", (Object)this.operationsConfig()).add("Status", (Object)this.statusAsString()).add("FailureDetails", (Object)this.failureDetails()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("CompletionTimestamp", (Object)this.completionTimestamp()).add("Input", (Object)this.input()).add("OutputConfig", (Object)this.outputConfig()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Results", (Object)this.results()).add("ManifestSummary", (Object)this.manifestSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "OperationsConfig": {
                return Optional.ofNullable(clazz.cast(this.operationsConfig()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FailureDetails": {
                return Optional.ofNullable(clazz.cast(this.failureDetails()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "CompletionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.completionTimestamp()));
            }
            case "Input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
            case "ManifestSummary": {
                return Optional.ofNullable(clazz.cast(this.manifestSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("JobName", JOB_NAME_FIELD);
        map.put("OperationsConfig", OPERATIONS_CONFIG_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("FailureDetails", FAILURE_DETAILS_FIELD);
        map.put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("CompletionTimestamp", COMPLETION_TIMESTAMP_FIELD);
        map.put("Input", INPUT_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Results", RESULTS_FIELD);
        map.put("ManifestSummary", MANIFEST_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMediaAnalysisJobResponse, T> g) {
        return obj -> g.apply((GetMediaAnalysisJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private String jobId;
        private String jobName;
        private MediaAnalysisOperationsConfig operationsConfig;
        private String status;
        private MediaAnalysisJobFailureDetails failureDetails;
        private Instant creationTimestamp;
        private Instant completionTimestamp;
        private MediaAnalysisInput input;
        private MediaAnalysisOutputConfig outputConfig;
        private String kmsKeyId;
        private MediaAnalysisResults results;
        private MediaAnalysisManifestSummary manifestSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMediaAnalysisJobResponse model) {
            super(model);
            this.jobId(model.jobId);
            this.jobName(model.jobName);
            this.operationsConfig(model.operationsConfig);
            this.status(model.status);
            this.failureDetails(model.failureDetails);
            this.creationTimestamp(model.creationTimestamp);
            this.completionTimestamp(model.completionTimestamp);
            this.input(model.input);
            this.outputConfig(model.outputConfig);
            this.kmsKeyId(model.kmsKeyId);
            this.results(model.results);
            this.manifestSummary(model.manifestSummary);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final MediaAnalysisOperationsConfig.Builder getOperationsConfig() {
            return this.operationsConfig != null ? this.operationsConfig.toBuilder() : null;
        }

        public final void setOperationsConfig(MediaAnalysisOperationsConfig.BuilderImpl operationsConfig) {
            this.operationsConfig = operationsConfig != null ? operationsConfig.build() : null;
        }

        @Override
        public final Builder operationsConfig(MediaAnalysisOperationsConfig operationsConfig) {
            this.operationsConfig = operationsConfig;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MediaAnalysisJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final MediaAnalysisJobFailureDetails.Builder getFailureDetails() {
            return this.failureDetails != null ? this.failureDetails.toBuilder() : null;
        }

        public final void setFailureDetails(MediaAnalysisJobFailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        @Override
        public final Builder failureDetails(MediaAnalysisJobFailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Instant getCompletionTimestamp() {
            return this.completionTimestamp;
        }

        public final void setCompletionTimestamp(Instant completionTimestamp) {
            this.completionTimestamp = completionTimestamp;
        }

        @Override
        public final Builder completionTimestamp(Instant completionTimestamp) {
            this.completionTimestamp = completionTimestamp;
            return this;
        }

        public final MediaAnalysisInput.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        public final void setInput(MediaAnalysisInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(MediaAnalysisInput input) {
            this.input = input;
            return this;
        }

        public final MediaAnalysisOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(MediaAnalysisOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(MediaAnalysisOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final MediaAnalysisResults.Builder getResults() {
            return this.results != null ? this.results.toBuilder() : null;
        }

        public final void setResults(MediaAnalysisResults.BuilderImpl results) {
            this.results = results != null ? results.build() : null;
        }

        @Override
        public final Builder results(MediaAnalysisResults results) {
            this.results = results;
            return this;
        }

        public final MediaAnalysisManifestSummary.Builder getManifestSummary() {
            return this.manifestSummary != null ? this.manifestSummary.toBuilder() : null;
        }

        public final void setManifestSummary(MediaAnalysisManifestSummary.BuilderImpl manifestSummary) {
            this.manifestSummary = manifestSummary != null ? manifestSummary.build() : null;
        }

        @Override
        public final Builder manifestSummary(MediaAnalysisManifestSummary manifestSummary) {
            this.manifestSummary = manifestSummary;
            return this;
        }

        @Override
        public GetMediaAnalysisJobResponse build() {
            return new GetMediaAnalysisJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMediaAnalysisJobResponse> {
        public Builder jobId(String var1);

        public Builder jobName(String var1);

        public Builder operationsConfig(MediaAnalysisOperationsConfig var1);

        default public Builder operationsConfig(Consumer<MediaAnalysisOperationsConfig.Builder> operationsConfig) {
            return this.operationsConfig((MediaAnalysisOperationsConfig)((MediaAnalysisOperationsConfig.Builder)MediaAnalysisOperationsConfig.builder().applyMutation(operationsConfig)).build());
        }

        public Builder status(String var1);

        public Builder status(MediaAnalysisJobStatus var1);

        public Builder failureDetails(MediaAnalysisJobFailureDetails var1);

        default public Builder failureDetails(Consumer<MediaAnalysisJobFailureDetails.Builder> failureDetails) {
            return this.failureDetails((MediaAnalysisJobFailureDetails)((MediaAnalysisJobFailureDetails.Builder)MediaAnalysisJobFailureDetails.builder().applyMutation(failureDetails)).build());
        }

        public Builder creationTimestamp(Instant var1);

        public Builder completionTimestamp(Instant var1);

        public Builder input(MediaAnalysisInput var1);

        default public Builder input(Consumer<MediaAnalysisInput.Builder> input) {
            return this.input((MediaAnalysisInput)((MediaAnalysisInput.Builder)MediaAnalysisInput.builder().applyMutation(input)).build());
        }

        public Builder outputConfig(MediaAnalysisOutputConfig var1);

        default public Builder outputConfig(Consumer<MediaAnalysisOutputConfig.Builder> outputConfig) {
            return this.outputConfig((MediaAnalysisOutputConfig)((MediaAnalysisOutputConfig.Builder)MediaAnalysisOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder results(MediaAnalysisResults var1);

        default public Builder results(Consumer<MediaAnalysisResults.Builder> results) {
            return this.results((MediaAnalysisResults)((MediaAnalysisResults.Builder)MediaAnalysisResults.builder().applyMutation(results)).build());
        }

        public Builder manifestSummary(MediaAnalysisManifestSummary var1);

        default public Builder manifestSummary(Consumer<MediaAnalysisManifestSummary.Builder> manifestSummary) {
            return this.manifestSummary((MediaAnalysisManifestSummary)((MediaAnalysisManifestSummary.Builder)MediaAnalysisManifestSummary.builder().applyMutation(manifestSummary)).build());
        }
    }
}

