/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.FaceMatch;
import software.amazon.awssdk.services.rekognition.model.FaceMatchListCopier;
import software.amazon.awssdk.services.rekognition.model.PersonDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PersonMatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PersonMatch> {
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Timestamp").getter(PersonMatch.getter(PersonMatch::timestamp)).setter(PersonMatch.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<PersonDetail> PERSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Person").getter(PersonMatch.getter(PersonMatch::person)).setter(PersonMatch.setter(Builder::person)).constructor(PersonDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Person").build()}).build();
    private static final SdkField<List<FaceMatch>> FACE_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FaceMatches").getter(PersonMatch.getter(PersonMatch::faceMatches)).setter(PersonMatch.setter(Builder::faceMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceMatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FaceMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, PERSON_FIELD, FACE_MATCHES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PersonMatch.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long timestamp;
    private final PersonDetail person;
    private final List<FaceMatch> faceMatches;

    private PersonMatch(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.person = builder.person;
        this.faceMatches = builder.faceMatches;
    }

    public final Long timestamp() {
        return this.timestamp;
    }

    public final PersonDetail person() {
        return this.person;
    }

    public final boolean hasFaceMatches() {
        return this.faceMatches != null && !(this.faceMatches instanceof SdkAutoConstructList);
    }

    public final List<FaceMatch> faceMatches() {
        return this.faceMatches;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.person());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFaceMatches() ? this.faceMatches() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PersonMatch)) {
            return false;
        }
        PersonMatch other = (PersonMatch)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.person(), other.person()) && this.hasFaceMatches() == other.hasFaceMatches() && Objects.equals(this.faceMatches(), other.faceMatches());
    }

    public final String toString() {
        return ToString.builder((String)"PersonMatch").add("Timestamp", (Object)this.timestamp()).add("Person", (Object)this.person()).add("FaceMatches", this.hasFaceMatches() ? this.faceMatches() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "Person": {
                return Optional.ofNullable(clazz.cast(this.person()));
            }
            case "FaceMatches": {
                return Optional.ofNullable(clazz.cast(this.faceMatches()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("Person", PERSON_FIELD);
        map.put("FaceMatches", FACE_MATCHES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PersonMatch, T> g) {
        return obj -> g.apply((PersonMatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long timestamp;
        private PersonDetail person;
        private List<FaceMatch> faceMatches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PersonMatch model) {
            this.timestamp(model.timestamp);
            this.person(model.person);
            this.faceMatches(model.faceMatches);
        }

        public final Long getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final PersonDetail.Builder getPerson() {
            return this.person != null ? this.person.toBuilder() : null;
        }

        public final void setPerson(PersonDetail.BuilderImpl person) {
            this.person = person != null ? person.build() : null;
        }

        @Override
        public final Builder person(PersonDetail person) {
            this.person = person;
            return this;
        }

        public final List<FaceMatch.Builder> getFaceMatches() {
            List<FaceMatch.Builder> result = FaceMatchListCopier.copyToBuilder(this.faceMatches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFaceMatches(Collection<FaceMatch.BuilderImpl> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copyFromBuilder(faceMatches);
        }

        @Override
        public final Builder faceMatches(Collection<FaceMatch> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(FaceMatch ... faceMatches) {
            this.faceMatches(Arrays.asList(faceMatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(Consumer<FaceMatch.Builder> ... faceMatches) {
            this.faceMatches(Stream.of(faceMatches).map(c -> (FaceMatch)((FaceMatch.Builder)FaceMatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PersonMatch build() {
            return new PersonMatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PersonMatch> {
        public Builder timestamp(Long var1);

        public Builder person(PersonDetail var1);

        default public Builder person(Consumer<PersonDetail.Builder> person) {
            return this.person((PersonDetail)((PersonDetail.Builder)PersonDetail.builder().applyMutation(person)).build());
        }

        public Builder faceMatches(Collection<FaceMatch> var1);

        public Builder faceMatches(FaceMatch ... var1);

        public Builder faceMatches(Consumer<FaceMatch.Builder> ... var1);
    }
}

