/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FaceSearchSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FaceSearchSettings> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionId").getter(FaceSearchSettings.getter(FaceSearchSettings::collectionId)).setter(FaceSearchSettings.setter(Builder::collectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId").build()}).build();
    private static final SdkField<Float> FACE_MATCH_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("FaceMatchThreshold").getter(FaceSearchSettings.getter(FaceSearchSettings::faceMatchThreshold)).setter(FaceSearchSettings.setter(Builder::faceMatchThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceMatchThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD, FACE_MATCH_THRESHOLD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FaceSearchSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String collectionId;
    private final Float faceMatchThreshold;

    private FaceSearchSettings(BuilderImpl builder) {
        this.collectionId = builder.collectionId;
        this.faceMatchThreshold = builder.faceMatchThreshold;
    }

    public final String collectionId() {
        return this.collectionId;
    }

    public final Float faceMatchThreshold() {
        return this.faceMatchThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceMatchThreshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceSearchSettings)) {
            return false;
        }
        FaceSearchSettings other = (FaceSearchSettings)obj;
        return Objects.equals(this.collectionId(), other.collectionId()) && Objects.equals(this.faceMatchThreshold(), other.faceMatchThreshold());
    }

    public final String toString() {
        return ToString.builder((String)"FaceSearchSettings").add("CollectionId", (Object)this.collectionId()).add("FaceMatchThreshold", (Object)this.faceMatchThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionId": {
                return Optional.ofNullable(clazz.cast(this.collectionId()));
            }
            case "FaceMatchThreshold": {
                return Optional.ofNullable(clazz.cast(this.faceMatchThreshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CollectionId", COLLECTION_ID_FIELD);
        map.put("FaceMatchThreshold", FACE_MATCH_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FaceSearchSettings, T> g) {
        return obj -> g.apply((FaceSearchSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String collectionId;
        private Float faceMatchThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceSearchSettings model) {
            this.collectionId(model.collectionId);
            this.faceMatchThreshold(model.faceMatchThreshold);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final Float getFaceMatchThreshold() {
            return this.faceMatchThreshold;
        }

        public final void setFaceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
        }

        @Override
        public final Builder faceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
            return this;
        }

        public FaceSearchSettings build() {
            return new FaceSearchSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FaceSearchSettings> {
        public Builder collectionId(String var1);

        public Builder faceMatchThreshold(Float var1);
    }
}

