/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.CustomizationFeature;
import software.amazon.awssdk.services.rekognition.model.CustomizationFeatureConfig;
import software.amazon.awssdk.services.rekognition.model.EvaluationResult;
import software.amazon.awssdk.services.rekognition.model.GroundTruthManifest;
import software.amazon.awssdk.services.rekognition.model.OutputConfig;
import software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus;
import software.amazon.awssdk.services.rekognition.model.TestingDataResult;
import software.amazon.awssdk.services.rekognition.model.TrainingDataResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectVersionDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectVersionDescription> {
    private static final SdkField<String> PROJECT_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectVersionArn").getter(ProjectVersionDescription.getter(ProjectVersionDescription::projectVersionArn)).setter(ProjectVersionDescription.setter(Builder::projectVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectVersionArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimestamp").getter(ProjectVersionDescription.getter(ProjectVersionDescription::creationTimestamp)).setter(ProjectVersionDescription.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<Integer> MIN_INFERENCE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinInferenceUnits").getter(ProjectVersionDescription.getter(ProjectVersionDescription::minInferenceUnits)).setter(ProjectVersionDescription.setter(Builder::minInferenceUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinInferenceUnits").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ProjectVersionDescription.getter(ProjectVersionDescription::statusAsString)).setter(ProjectVersionDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ProjectVersionDescription.getter(ProjectVersionDescription::statusMessage)).setter(ProjectVersionDescription.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Long> BILLABLE_TRAINING_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BillableTrainingTimeInSeconds").getter(ProjectVersionDescription.getter(ProjectVersionDescription::billableTrainingTimeInSeconds)).setter(ProjectVersionDescription.setter(Builder::billableTrainingTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillableTrainingTimeInSeconds").build()}).build();
    private static final SdkField<Instant> TRAINING_END_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingEndTimestamp").getter(ProjectVersionDescription.getter(ProjectVersionDescription::trainingEndTimestamp)).setter(ProjectVersionDescription.setter(Builder::trainingEndTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingEndTimestamp").build()}).build();
    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(ProjectVersionDescription.getter(ProjectVersionDescription::outputConfig)).setter(ProjectVersionDescription.setter(Builder::outputConfig)).constructor(OutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<TrainingDataResult> TRAINING_DATA_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrainingDataResult").getter(ProjectVersionDescription.getter(ProjectVersionDescription::trainingDataResult)).setter(ProjectVersionDescription.setter(Builder::trainingDataResult)).constructor(TrainingDataResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataResult").build()}).build();
    private static final SdkField<TestingDataResult> TESTING_DATA_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TestingDataResult").getter(ProjectVersionDescription.getter(ProjectVersionDescription::testingDataResult)).setter(ProjectVersionDescription.setter(Builder::testingDataResult)).constructor(TestingDataResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestingDataResult").build()}).build();
    private static final SdkField<EvaluationResult> EVALUATION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EvaluationResult").getter(ProjectVersionDescription.getter(ProjectVersionDescription::evaluationResult)).setter(ProjectVersionDescription.setter(Builder::evaluationResult)).constructor(EvaluationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationResult").build()}).build();
    private static final SdkField<GroundTruthManifest> MANIFEST_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManifestSummary").getter(ProjectVersionDescription.getter(ProjectVersionDescription::manifestSummary)).setter(ProjectVersionDescription.setter(Builder::manifestSummary)).constructor(GroundTruthManifest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestSummary").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(ProjectVersionDescription.getter(ProjectVersionDescription::kmsKeyId)).setter(ProjectVersionDescription.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Integer> MAX_INFERENCE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxInferenceUnits").getter(ProjectVersionDescription.getter(ProjectVersionDescription::maxInferenceUnits)).setter(ProjectVersionDescription.setter(Builder::maxInferenceUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInferenceUnits").build()}).build();
    private static final SdkField<String> SOURCE_PROJECT_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceProjectVersionArn").getter(ProjectVersionDescription.getter(ProjectVersionDescription::sourceProjectVersionArn)).setter(ProjectVersionDescription.setter(Builder::sourceProjectVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceProjectVersionArn").build()}).build();
    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionDescription").getter(ProjectVersionDescription.getter(ProjectVersionDescription::versionDescription)).setter(ProjectVersionDescription.setter(Builder::versionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build()}).build();
    private static final SdkField<String> FEATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Feature").getter(ProjectVersionDescription.getter(ProjectVersionDescription::featureAsString)).setter(ProjectVersionDescription.setter(Builder::feature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feature").build()}).build();
    private static final SdkField<String> BASE_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseModelVersion").getter(ProjectVersionDescription.getter(ProjectVersionDescription::baseModelVersion)).setter(ProjectVersionDescription.setter(Builder::baseModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseModelVersion").build()}).build();
    private static final SdkField<CustomizationFeatureConfig> FEATURE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FeatureConfig").getter(ProjectVersionDescription.getter(ProjectVersionDescription::featureConfig)).setter(ProjectVersionDescription.setter(Builder::featureConfig)).constructor(CustomizationFeatureConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_VERSION_ARN_FIELD, CREATION_TIMESTAMP_FIELD, MIN_INFERENCE_UNITS_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, BILLABLE_TRAINING_TIME_IN_SECONDS_FIELD, TRAINING_END_TIMESTAMP_FIELD, OUTPUT_CONFIG_FIELD, TRAINING_DATA_RESULT_FIELD, TESTING_DATA_RESULT_FIELD, EVALUATION_RESULT_FIELD, MANIFEST_SUMMARY_FIELD, KMS_KEY_ID_FIELD, MAX_INFERENCE_UNITS_FIELD, SOURCE_PROJECT_VERSION_ARN_FIELD, VERSION_DESCRIPTION_FIELD, FEATURE_FIELD, BASE_MODEL_VERSION_FIELD, FEATURE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProjectVersionDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String projectVersionArn;
    private final Instant creationTimestamp;
    private final Integer minInferenceUnits;
    private final String status;
    private final String statusMessage;
    private final Long billableTrainingTimeInSeconds;
    private final Instant trainingEndTimestamp;
    private final OutputConfig outputConfig;
    private final TrainingDataResult trainingDataResult;
    private final TestingDataResult testingDataResult;
    private final EvaluationResult evaluationResult;
    private final GroundTruthManifest manifestSummary;
    private final String kmsKeyId;
    private final Integer maxInferenceUnits;
    private final String sourceProjectVersionArn;
    private final String versionDescription;
    private final String feature;
    private final String baseModelVersion;
    private final CustomizationFeatureConfig featureConfig;

    private ProjectVersionDescription(BuilderImpl builder) {
        this.projectVersionArn = builder.projectVersionArn;
        this.creationTimestamp = builder.creationTimestamp;
        this.minInferenceUnits = builder.minInferenceUnits;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.billableTrainingTimeInSeconds = builder.billableTrainingTimeInSeconds;
        this.trainingEndTimestamp = builder.trainingEndTimestamp;
        this.outputConfig = builder.outputConfig;
        this.trainingDataResult = builder.trainingDataResult;
        this.testingDataResult = builder.testingDataResult;
        this.evaluationResult = builder.evaluationResult;
        this.manifestSummary = builder.manifestSummary;
        this.kmsKeyId = builder.kmsKeyId;
        this.maxInferenceUnits = builder.maxInferenceUnits;
        this.sourceProjectVersionArn = builder.sourceProjectVersionArn;
        this.versionDescription = builder.versionDescription;
        this.feature = builder.feature;
        this.baseModelVersion = builder.baseModelVersion;
        this.featureConfig = builder.featureConfig;
    }

    public final String projectVersionArn() {
        return this.projectVersionArn;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final Integer minInferenceUnits() {
        return this.minInferenceUnits;
    }

    public final ProjectVersionStatus status() {
        return ProjectVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Long billableTrainingTimeInSeconds() {
        return this.billableTrainingTimeInSeconds;
    }

    public final Instant trainingEndTimestamp() {
        return this.trainingEndTimestamp;
    }

    public final OutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final TrainingDataResult trainingDataResult() {
        return this.trainingDataResult;
    }

    public final TestingDataResult testingDataResult() {
        return this.testingDataResult;
    }

    public final EvaluationResult evaluationResult() {
        return this.evaluationResult;
    }

    public final GroundTruthManifest manifestSummary() {
        return this.manifestSummary;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Integer maxInferenceUnits() {
        return this.maxInferenceUnits;
    }

    public final String sourceProjectVersionArn() {
        return this.sourceProjectVersionArn;
    }

    public final String versionDescription() {
        return this.versionDescription;
    }

    public final CustomizationFeature feature() {
        return CustomizationFeature.fromValue(this.feature);
    }

    public final String featureAsString() {
        return this.feature;
    }

    public final String baseModelVersion() {
        return this.baseModelVersion;
    }

    public final CustomizationFeatureConfig featureConfig() {
        return this.featureConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.minInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.billableTrainingTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingEndTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.testingDataResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceProjectVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectVersionDescription)) {
            return false;
        }
        ProjectVersionDescription other = (ProjectVersionDescription)obj;
        return Objects.equals(this.projectVersionArn(), other.projectVersionArn()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.minInferenceUnits(), other.minInferenceUnits()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.billableTrainingTimeInSeconds(), other.billableTrainingTimeInSeconds()) && Objects.equals(this.trainingEndTimestamp(), other.trainingEndTimestamp()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.trainingDataResult(), other.trainingDataResult()) && Objects.equals(this.testingDataResult(), other.testingDataResult()) && Objects.equals(this.evaluationResult(), other.evaluationResult()) && Objects.equals(this.manifestSummary(), other.manifestSummary()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.maxInferenceUnits(), other.maxInferenceUnits()) && Objects.equals(this.sourceProjectVersionArn(), other.sourceProjectVersionArn()) && Objects.equals(this.versionDescription(), other.versionDescription()) && Objects.equals(this.featureAsString(), other.featureAsString()) && Objects.equals(this.baseModelVersion(), other.baseModelVersion()) && Objects.equals(this.featureConfig(), other.featureConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ProjectVersionDescription").add("ProjectVersionArn", (Object)this.projectVersionArn()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("MinInferenceUnits", (Object)this.minInferenceUnits()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("BillableTrainingTimeInSeconds", (Object)this.billableTrainingTimeInSeconds()).add("TrainingEndTimestamp", (Object)this.trainingEndTimestamp()).add("OutputConfig", (Object)this.outputConfig()).add("TrainingDataResult", (Object)this.trainingDataResult()).add("TestingDataResult", (Object)this.testingDataResult()).add("EvaluationResult", (Object)this.evaluationResult()).add("ManifestSummary", (Object)this.manifestSummary()).add("KmsKeyId", (Object)this.kmsKeyId()).add("MaxInferenceUnits", (Object)this.maxInferenceUnits()).add("SourceProjectVersionArn", (Object)this.sourceProjectVersionArn()).add("VersionDescription", (Object)this.versionDescription()).add("Feature", (Object)this.featureAsString()).add("BaseModelVersion", (Object)this.baseModelVersion()).add("FeatureConfig", (Object)this.featureConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectVersionArn": {
                return Optional.ofNullable(clazz.cast(this.projectVersionArn()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "MinInferenceUnits": {
                return Optional.ofNullable(clazz.cast(this.minInferenceUnits()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "BillableTrainingTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.billableTrainingTimeInSeconds()));
            }
            case "TrainingEndTimestamp": {
                return Optional.ofNullable(clazz.cast(this.trainingEndTimestamp()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "TrainingDataResult": {
                return Optional.ofNullable(clazz.cast(this.trainingDataResult()));
            }
            case "TestingDataResult": {
                return Optional.ofNullable(clazz.cast(this.testingDataResult()));
            }
            case "EvaluationResult": {
                return Optional.ofNullable(clazz.cast(this.evaluationResult()));
            }
            case "ManifestSummary": {
                return Optional.ofNullable(clazz.cast(this.manifestSummary()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "MaxInferenceUnits": {
                return Optional.ofNullable(clazz.cast(this.maxInferenceUnits()));
            }
            case "SourceProjectVersionArn": {
                return Optional.ofNullable(clazz.cast(this.sourceProjectVersionArn()));
            }
            case "VersionDescription": {
                return Optional.ofNullable(clazz.cast(this.versionDescription()));
            }
            case "Feature": {
                return Optional.ofNullable(clazz.cast(this.featureAsString()));
            }
            case "BaseModelVersion": {
                return Optional.ofNullable(clazz.cast(this.baseModelVersion()));
            }
            case "FeatureConfig": {
                return Optional.ofNullable(clazz.cast(this.featureConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProjectVersionArn", PROJECT_VERSION_ARN_FIELD);
        map.put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("MinInferenceUnits", MIN_INFERENCE_UNITS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("BillableTrainingTimeInSeconds", BILLABLE_TRAINING_TIME_IN_SECONDS_FIELD);
        map.put("TrainingEndTimestamp", TRAINING_END_TIMESTAMP_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("TrainingDataResult", TRAINING_DATA_RESULT_FIELD);
        map.put("TestingDataResult", TESTING_DATA_RESULT_FIELD);
        map.put("EvaluationResult", EVALUATION_RESULT_FIELD);
        map.put("ManifestSummary", MANIFEST_SUMMARY_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("MaxInferenceUnits", MAX_INFERENCE_UNITS_FIELD);
        map.put("SourceProjectVersionArn", SOURCE_PROJECT_VERSION_ARN_FIELD);
        map.put("VersionDescription", VERSION_DESCRIPTION_FIELD);
        map.put("Feature", FEATURE_FIELD);
        map.put("BaseModelVersion", BASE_MODEL_VERSION_FIELD);
        map.put("FeatureConfig", FEATURE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProjectVersionDescription, T> g) {
        return obj -> g.apply((ProjectVersionDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String projectVersionArn;
        private Instant creationTimestamp;
        private Integer minInferenceUnits;
        private String status;
        private String statusMessage;
        private Long billableTrainingTimeInSeconds;
        private Instant trainingEndTimestamp;
        private OutputConfig outputConfig;
        private TrainingDataResult trainingDataResult;
        private TestingDataResult testingDataResult;
        private EvaluationResult evaluationResult;
        private GroundTruthManifest manifestSummary;
        private String kmsKeyId;
        private Integer maxInferenceUnits;
        private String sourceProjectVersionArn;
        private String versionDescription;
        private String feature;
        private String baseModelVersion;
        private CustomizationFeatureConfig featureConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectVersionDescription model) {
            this.projectVersionArn(model.projectVersionArn);
            this.creationTimestamp(model.creationTimestamp);
            this.minInferenceUnits(model.minInferenceUnits);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.billableTrainingTimeInSeconds(model.billableTrainingTimeInSeconds);
            this.trainingEndTimestamp(model.trainingEndTimestamp);
            this.outputConfig(model.outputConfig);
            this.trainingDataResult(model.trainingDataResult);
            this.testingDataResult(model.testingDataResult);
            this.evaluationResult(model.evaluationResult);
            this.manifestSummary(model.manifestSummary);
            this.kmsKeyId(model.kmsKeyId);
            this.maxInferenceUnits(model.maxInferenceUnits);
            this.sourceProjectVersionArn(model.sourceProjectVersionArn);
            this.versionDescription(model.versionDescription);
            this.feature(model.feature);
            this.baseModelVersion(model.baseModelVersion);
            this.featureConfig(model.featureConfig);
        }

        public final String getProjectVersionArn() {
            return this.projectVersionArn;
        }

        public final void setProjectVersionArn(String projectVersionArn) {
            this.projectVersionArn = projectVersionArn;
        }

        @Override
        public final Builder projectVersionArn(String projectVersionArn) {
            this.projectVersionArn = projectVersionArn;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Integer getMinInferenceUnits() {
            return this.minInferenceUnits;
        }

        public final void setMinInferenceUnits(Integer minInferenceUnits) {
            this.minInferenceUnits = minInferenceUnits;
        }

        @Override
        public final Builder minInferenceUnits(Integer minInferenceUnits) {
            this.minInferenceUnits = minInferenceUnits;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProjectVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Long getBillableTrainingTimeInSeconds() {
            return this.billableTrainingTimeInSeconds;
        }

        public final void setBillableTrainingTimeInSeconds(Long billableTrainingTimeInSeconds) {
            this.billableTrainingTimeInSeconds = billableTrainingTimeInSeconds;
        }

        @Override
        public final Builder billableTrainingTimeInSeconds(Long billableTrainingTimeInSeconds) {
            this.billableTrainingTimeInSeconds = billableTrainingTimeInSeconds;
            return this;
        }

        public final Instant getTrainingEndTimestamp() {
            return this.trainingEndTimestamp;
        }

        public final void setTrainingEndTimestamp(Instant trainingEndTimestamp) {
            this.trainingEndTimestamp = trainingEndTimestamp;
        }

        @Override
        public final Builder trainingEndTimestamp(Instant trainingEndTimestamp) {
            this.trainingEndTimestamp = trainingEndTimestamp;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final TrainingDataResult.Builder getTrainingDataResult() {
            return this.trainingDataResult != null ? this.trainingDataResult.toBuilder() : null;
        }

        public final void setTrainingDataResult(TrainingDataResult.BuilderImpl trainingDataResult) {
            this.trainingDataResult = trainingDataResult != null ? trainingDataResult.build() : null;
        }

        @Override
        public final Builder trainingDataResult(TrainingDataResult trainingDataResult) {
            this.trainingDataResult = trainingDataResult;
            return this;
        }

        public final TestingDataResult.Builder getTestingDataResult() {
            return this.testingDataResult != null ? this.testingDataResult.toBuilder() : null;
        }

        public final void setTestingDataResult(TestingDataResult.BuilderImpl testingDataResult) {
            this.testingDataResult = testingDataResult != null ? testingDataResult.build() : null;
        }

        @Override
        public final Builder testingDataResult(TestingDataResult testingDataResult) {
            this.testingDataResult = testingDataResult;
            return this;
        }

        public final EvaluationResult.Builder getEvaluationResult() {
            return this.evaluationResult != null ? this.evaluationResult.toBuilder() : null;
        }

        public final void setEvaluationResult(EvaluationResult.BuilderImpl evaluationResult) {
            this.evaluationResult = evaluationResult != null ? evaluationResult.build() : null;
        }

        @Override
        public final Builder evaluationResult(EvaluationResult evaluationResult) {
            this.evaluationResult = evaluationResult;
            return this;
        }

        public final GroundTruthManifest.Builder getManifestSummary() {
            return this.manifestSummary != null ? this.manifestSummary.toBuilder() : null;
        }

        public final void setManifestSummary(GroundTruthManifest.BuilderImpl manifestSummary) {
            this.manifestSummary = manifestSummary != null ? manifestSummary.build() : null;
        }

        @Override
        public final Builder manifestSummary(GroundTruthManifest manifestSummary) {
            this.manifestSummary = manifestSummary;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Integer getMaxInferenceUnits() {
            return this.maxInferenceUnits;
        }

        public final void setMaxInferenceUnits(Integer maxInferenceUnits) {
            this.maxInferenceUnits = maxInferenceUnits;
        }

        @Override
        public final Builder maxInferenceUnits(Integer maxInferenceUnits) {
            this.maxInferenceUnits = maxInferenceUnits;
            return this;
        }

        public final String getSourceProjectVersionArn() {
            return this.sourceProjectVersionArn;
        }

        public final void setSourceProjectVersionArn(String sourceProjectVersionArn) {
            this.sourceProjectVersionArn = sourceProjectVersionArn;
        }

        @Override
        public final Builder sourceProjectVersionArn(String sourceProjectVersionArn) {
            this.sourceProjectVersionArn = sourceProjectVersionArn;
            return this;
        }

        public final String getVersionDescription() {
            return this.versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final String getFeature() {
            return this.feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public final Builder feature(CustomizationFeature feature) {
            this.feature(feature == null ? null : feature.toString());
            return this;
        }

        public final String getBaseModelVersion() {
            return this.baseModelVersion;
        }

        public final void setBaseModelVersion(String baseModelVersion) {
            this.baseModelVersion = baseModelVersion;
        }

        @Override
        public final Builder baseModelVersion(String baseModelVersion) {
            this.baseModelVersion = baseModelVersion;
            return this;
        }

        public final CustomizationFeatureConfig.Builder getFeatureConfig() {
            return this.featureConfig != null ? this.featureConfig.toBuilder() : null;
        }

        public final void setFeatureConfig(CustomizationFeatureConfig.BuilderImpl featureConfig) {
            this.featureConfig = featureConfig != null ? featureConfig.build() : null;
        }

        @Override
        public final Builder featureConfig(CustomizationFeatureConfig featureConfig) {
            this.featureConfig = featureConfig;
            return this;
        }

        public ProjectVersionDescription build() {
            return new ProjectVersionDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectVersionDescription> {
        public Builder projectVersionArn(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder minInferenceUnits(Integer var1);

        public Builder status(String var1);

        public Builder status(ProjectVersionStatus var1);

        public Builder statusMessage(String var1);

        public Builder billableTrainingTimeInSeconds(Long var1);

        public Builder trainingEndTimestamp(Instant var1);

        public Builder outputConfig(OutputConfig var1);

        default public Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return this.outputConfig((OutputConfig)((OutputConfig.Builder)OutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder trainingDataResult(TrainingDataResult var1);

        default public Builder trainingDataResult(Consumer<TrainingDataResult.Builder> trainingDataResult) {
            return this.trainingDataResult((TrainingDataResult)((TrainingDataResult.Builder)TrainingDataResult.builder().applyMutation(trainingDataResult)).build());
        }

        public Builder testingDataResult(TestingDataResult var1);

        default public Builder testingDataResult(Consumer<TestingDataResult.Builder> testingDataResult) {
            return this.testingDataResult((TestingDataResult)((TestingDataResult.Builder)TestingDataResult.builder().applyMutation(testingDataResult)).build());
        }

        public Builder evaluationResult(EvaluationResult var1);

        default public Builder evaluationResult(Consumer<EvaluationResult.Builder> evaluationResult) {
            return this.evaluationResult((EvaluationResult)((EvaluationResult.Builder)EvaluationResult.builder().applyMutation(evaluationResult)).build());
        }

        public Builder manifestSummary(GroundTruthManifest var1);

        default public Builder manifestSummary(Consumer<GroundTruthManifest.Builder> manifestSummary) {
            return this.manifestSummary((GroundTruthManifest)((GroundTruthManifest.Builder)GroundTruthManifest.builder().applyMutation(manifestSummary)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder maxInferenceUnits(Integer var1);

        public Builder sourceProjectVersionArn(String var1);

        public Builder versionDescription(String var1);

        public Builder feature(String var1);

        public Builder feature(CustomizationFeature var1);

        public Builder baseModelVersion(String var1);

        public Builder featureConfig(CustomizationFeatureConfig var1);

        default public Builder featureConfig(Consumer<CustomizationFeatureConfig.Builder> featureConfig) {
            return this.featureConfig((CustomizationFeatureConfig)((CustomizationFeatureConfig.Builder)CustomizationFeatureConfig.builder().applyMutation(featureConfig)).build());
        }
    }
}

