/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.DatasetChanges;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDatasetEntriesRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, UpdateDatasetEntriesRequest> {
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetArn").getter(UpdateDatasetEntriesRequest.getter(UpdateDatasetEntriesRequest::datasetArn)).setter(UpdateDatasetEntriesRequest.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()}).build();
    private static final SdkField<DatasetChanges> CHANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Changes").getter(UpdateDatasetEntriesRequest.getter(UpdateDatasetEntriesRequest::changes)).setter(UpdateDatasetEntriesRequest.setter(Builder::changes)).constructor(DatasetChanges::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Changes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ARN_FIELD, CHANGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDatasetEntriesRequest.memberNameToFieldInitializer();
    private final String datasetArn;
    private final DatasetChanges changes;

    private UpdateDatasetEntriesRequest(BuilderImpl builder) {
        super(builder);
        this.datasetArn = builder.datasetArn;
        this.changes = builder.changes;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final DatasetChanges changes() {
        return this.changes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.changes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatasetEntriesRequest)) {
            return false;
        }
        UpdateDatasetEntriesRequest other = (UpdateDatasetEntriesRequest)((Object)obj);
        return Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.changes(), other.changes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDatasetEntriesRequest").add("DatasetArn", (Object)this.datasetArn()).add("Changes", (Object)this.changes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "Changes": {
                return Optional.ofNullable(clazz.cast(this.changes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DatasetArn", DATASET_ARN_FIELD);
        map.put("Changes", CHANGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatasetEntriesRequest, T> g) {
        return obj -> g.apply((UpdateDatasetEntriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String datasetArn;
        private DatasetChanges changes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatasetEntriesRequest model) {
            super(model);
            this.datasetArn(model.datasetArn);
            this.changes(model.changes);
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final DatasetChanges.Builder getChanges() {
            return this.changes != null ? this.changes.toBuilder() : null;
        }

        public final void setChanges(DatasetChanges.BuilderImpl changes) {
            this.changes = changes != null ? changes.build() : null;
        }

        @Override
        public final Builder changes(DatasetChanges changes) {
            this.changes = changes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatasetEntriesRequest build() {
            return new UpdateDatasetEntriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDatasetEntriesRequest> {
        public Builder datasetArn(String var1);

        public Builder changes(DatasetChanges var1);

        default public Builder changes(Consumer<DatasetChanges.Builder> changes) {
            return this.changes((DatasetChanges)((DatasetChanges.Builder)DatasetChanges.builder().applyMutation(changes)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

