/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsFeatureListCopier;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsFeatureName;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsSettings;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectLabelsRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, DetectLabelsRequest> {
    private static final SdkField<Image> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Image").getter(DetectLabelsRequest.getter(DetectLabelsRequest::image)).setter(DetectLabelsRequest.setter(Builder::image)).constructor(Image::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()}).build();
    private static final SdkField<Integer> MAX_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxLabels").getter(DetectLabelsRequest.getter(DetectLabelsRequest::maxLabels)).setter(DetectLabelsRequest.setter(Builder::maxLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxLabels").build()}).build();
    private static final SdkField<Float> MIN_CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("MinConfidence").getter(DetectLabelsRequest.getter(DetectLabelsRequest::minConfidence)).setter(DetectLabelsRequest.setter(Builder::minConfidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinConfidence").build()}).build();
    private static final SdkField<List<String>> FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Features").getter(DetectLabelsRequest.getter(DetectLabelsRequest::featuresAsStrings)).setter(DetectLabelsRequest.setter(Builder::featuresWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Features").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DetectLabelsSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(DetectLabelsRequest.getter(DetectLabelsRequest::settings)).setter(DetectLabelsRequest.setter(Builder::settings)).constructor(DetectLabelsSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD, MAX_LABELS_FIELD, MIN_CONFIDENCE_FIELD, FEATURES_FIELD, SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DetectLabelsRequest.memberNameToFieldInitializer();
    private final Image image;
    private final Integer maxLabels;
    private final Float minConfidence;
    private final List<String> features;
    private final DetectLabelsSettings settings;

    private DetectLabelsRequest(BuilderImpl builder) {
        super(builder);
        this.image = builder.image;
        this.maxLabels = builder.maxLabels;
        this.minConfidence = builder.minConfidence;
        this.features = builder.features;
        this.settings = builder.settings;
    }

    public final Image image() {
        return this.image;
    }

    public final Integer maxLabels() {
        return this.maxLabels;
    }

    public final Float minConfidence() {
        return this.minConfidence;
    }

    public final List<DetectLabelsFeatureName> features() {
        return DetectLabelsFeatureListCopier.copyStringToEnum(this.features);
    }

    public final boolean hasFeatures() {
        return this.features != null && !(this.features instanceof SdkAutoConstructList);
    }

    public final List<String> featuresAsStrings() {
        return this.features;
    }

    public final DetectLabelsSettings settings() {
        return this.settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.minConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatures() ? this.featuresAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsRequest)) {
            return false;
        }
        DetectLabelsRequest other = (DetectLabelsRequest)((Object)obj);
        return Objects.equals(this.image(), other.image()) && Objects.equals(this.maxLabels(), other.maxLabels()) && Objects.equals(this.minConfidence(), other.minConfidence()) && this.hasFeatures() == other.hasFeatures() && Objects.equals(this.featuresAsStrings(), other.featuresAsStrings()) && Objects.equals(this.settings(), other.settings());
    }

    public final String toString() {
        return ToString.builder((String)"DetectLabelsRequest").add("Image", (Object)this.image()).add("MaxLabels", (Object)this.maxLabels()).add("MinConfidence", (Object)this.minConfidence()).add("Features", this.hasFeatures() ? this.featuresAsStrings() : null).add("Settings", (Object)this.settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "MaxLabels": {
                return Optional.ofNullable(clazz.cast(this.maxLabels()));
            }
            case "MinConfidence": {
                return Optional.ofNullable(clazz.cast(this.minConfidence()));
            }
            case "Features": {
                return Optional.ofNullable(clazz.cast(this.featuresAsStrings()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Image", IMAGE_FIELD);
        map.put("MaxLabels", MAX_LABELS_FIELD);
        map.put("MinConfidence", MIN_CONFIDENCE_FIELD);
        map.put("Features", FEATURES_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectLabelsRequest, T> g) {
        return obj -> g.apply((DetectLabelsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private Image image;
        private Integer maxLabels;
        private Float minConfidence;
        private List<String> features = DefaultSdkAutoConstructList.getInstance();
        private DetectLabelsSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectLabelsRequest model) {
            super(model);
            this.image(model.image);
            this.maxLabels(model.maxLabels);
            this.minConfidence(model.minConfidence);
            this.featuresWithStrings(model.features);
            this.settings(model.settings);
        }

        public final Image.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final Integer getMaxLabels() {
            return this.maxLabels;
        }

        public final void setMaxLabels(Integer maxLabels) {
            this.maxLabels = maxLabels;
        }

        @Override
        public final Builder maxLabels(Integer maxLabels) {
            this.maxLabels = maxLabels;
            return this;
        }

        public final Float getMinConfidence() {
            return this.minConfidence;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        @Override
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        public final Collection<String> getFeatures() {
            if (this.features instanceof SdkAutoConstructList) {
                return null;
            }
            return this.features;
        }

        public final void setFeatures(Collection<String> features) {
            this.features = DetectLabelsFeatureListCopier.copy(features);
        }

        @Override
        public final Builder featuresWithStrings(Collection<String> features) {
            this.features = DetectLabelsFeatureListCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuresWithStrings(String ... features) {
            this.featuresWithStrings(Arrays.asList(features));
            return this;
        }

        @Override
        public final Builder features(Collection<DetectLabelsFeatureName> features) {
            this.features = DetectLabelsFeatureListCopier.copyEnumToString(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(DetectLabelsFeatureName ... features) {
            this.features(Arrays.asList(features));
            return this;
        }

        public final DetectLabelsSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(DetectLabelsSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(DetectLabelsSettings settings) {
            this.settings = settings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectLabelsRequest build() {
            return new DetectLabelsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectLabelsRequest> {
        public Builder image(Image var1);

        default public Builder image(Consumer<Image.Builder> image) {
            return this.image((Image)((Image.Builder)Image.builder().applyMutation(image)).build());
        }

        public Builder maxLabels(Integer var1);

        public Builder minConfidence(Float var1);

        public Builder featuresWithStrings(Collection<String> var1);

        public Builder featuresWithStrings(String ... var1);

        public Builder features(Collection<DetectLabelsFeatureName> var1);

        public Builder features(DetectLabelsFeatureName ... var1);

        public Builder settings(DetectLabelsSettings var1);

        default public Builder settings(Consumer<DetectLabelsSettings.Builder> settings) {
            return this.settings((DetectLabelsSettings)((DetectLabelsSettings.Builder)DetectLabelsSettings.builder().applyMutation(settings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

