/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.model.FaceDetail;
import software.amazon.awssdk.services.rekognition.model.KnownGender;
import software.amazon.awssdk.services.rekognition.model.UrlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CelebrityDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CelebrityDetail> {
    private static final SdkField<List<String>> URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Urls").getter(CelebrityDetail.getter(CelebrityDetail::urls)).setter(CelebrityDetail.setter(Builder::urls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Urls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CelebrityDetail.getter(CelebrityDetail::name)).setter(CelebrityDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CelebrityDetail.getter(CelebrityDetail::id)).setter(CelebrityDetail.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(CelebrityDetail.getter(CelebrityDetail::confidence)).setter(CelebrityDetail.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BoundingBox").getter(CelebrityDetail.getter(CelebrityDetail::boundingBox)).setter(CelebrityDetail.setter(Builder::boundingBox)).constructor(BoundingBox::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()}).build();
    private static final SdkField<FaceDetail> FACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Face").getter(CelebrityDetail.getter(CelebrityDetail::face)).setter(CelebrityDetail.setter(Builder::face)).constructor(FaceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Face").build()}).build();
    private static final SdkField<KnownGender> KNOWN_GENDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KnownGender").getter(CelebrityDetail.getter(CelebrityDetail::knownGender)).setter(CelebrityDetail.setter(Builder::knownGender)).constructor(KnownGender::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KnownGender").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URLS_FIELD, NAME_FIELD, ID_FIELD, CONFIDENCE_FIELD, BOUNDING_BOX_FIELD, FACE_FIELD, KNOWN_GENDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CelebrityDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> urls;
    private final String name;
    private final String id;
    private final Float confidence;
    private final BoundingBox boundingBox;
    private final FaceDetail face;
    private final KnownGender knownGender;

    private CelebrityDetail(BuilderImpl builder) {
        this.urls = builder.urls;
        this.name = builder.name;
        this.id = builder.id;
        this.confidence = builder.confidence;
        this.boundingBox = builder.boundingBox;
        this.face = builder.face;
        this.knownGender = builder.knownGender;
    }

    public final boolean hasUrls() {
        return this.urls != null && !(this.urls instanceof SdkAutoConstructList);
    }

    public final List<String> urls() {
        return this.urls;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final Float confidence() {
        return this.confidence;
    }

    public final BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public final FaceDetail face() {
        return this.face;
    }

    public final KnownGender knownGender() {
        return this.knownGender;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUrls() ? this.urls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(this.face());
        hashCode = 31 * hashCode + Objects.hashCode(this.knownGender());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CelebrityDetail)) {
            return false;
        }
        CelebrityDetail other = (CelebrityDetail)obj;
        return this.hasUrls() == other.hasUrls() && Objects.equals(this.urls(), other.urls()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.boundingBox(), other.boundingBox()) && Objects.equals(this.face(), other.face()) && Objects.equals(this.knownGender(), other.knownGender());
    }

    public final String toString() {
        return ToString.builder((String)"CelebrityDetail").add("Urls", this.hasUrls() ? this.urls() : null).add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("Confidence", (Object)this.confidence()).add("BoundingBox", (Object)this.boundingBox()).add("Face", (Object)this.face()).add("KnownGender", (Object)this.knownGender()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Urls": {
                return Optional.ofNullable(clazz.cast(this.urls()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "Face": {
                return Optional.ofNullable(clazz.cast(this.face()));
            }
            case "KnownGender": {
                return Optional.ofNullable(clazz.cast(this.knownGender()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Urls", URLS_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("BoundingBox", BOUNDING_BOX_FIELD);
        map.put("Face", FACE_FIELD);
        map.put("KnownGender", KNOWN_GENDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CelebrityDetail, T> g) {
        return obj -> g.apply((CelebrityDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> urls = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String id;
        private Float confidence;
        private BoundingBox boundingBox;
        private FaceDetail face;
        private KnownGender knownGender;

        private BuilderImpl() {
        }

        private BuilderImpl(CelebrityDetail model) {
            this.urls(model.urls);
            this.name(model.name);
            this.id(model.id);
            this.confidence(model.confidence);
            this.boundingBox(model.boundingBox);
            this.face(model.face);
            this.knownGender(model.knownGender);
        }

        public final Collection<String> getUrls() {
            if (this.urls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.urls;
        }

        public final void setUrls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
        }

        @Override
        public final Builder urls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder urls(String ... urls) {
            this.urls(Arrays.asList(urls));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final BoundingBox.Builder getBoundingBox() {
            return this.boundingBox != null ? this.boundingBox.toBuilder() : null;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final FaceDetail.Builder getFace() {
            return this.face != null ? this.face.toBuilder() : null;
        }

        public final void setFace(FaceDetail.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        @Override
        public final Builder face(FaceDetail face) {
            this.face = face;
            return this;
        }

        public final KnownGender.Builder getKnownGender() {
            return this.knownGender != null ? this.knownGender.toBuilder() : null;
        }

        public final void setKnownGender(KnownGender.BuilderImpl knownGender) {
            this.knownGender = knownGender != null ? knownGender.build() : null;
        }

        @Override
        public final Builder knownGender(KnownGender knownGender) {
            this.knownGender = knownGender;
            return this;
        }

        public CelebrityDetail build() {
            return new CelebrityDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CelebrityDetail> {
        public Builder urls(Collection<String> var1);

        public Builder urls(String ... var1);

        public Builder name(String var1);

        public Builder id(String var1);

        public Builder confidence(Float var1);

        public Builder boundingBox(BoundingBox var1);

        default public Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return this.boundingBox((BoundingBox)((BoundingBox.Builder)BoundingBox.builder().applyMutation(boundingBox)).build());
        }

        public Builder face(FaceDetail var1);

        default public Builder face(Consumer<FaceDetail.Builder> face) {
            return this.face((FaceDetail)((FaceDetail.Builder)FaceDetail.builder().applyMutation(face)).build());
        }

        public Builder knownGender(KnownGender var1);

        default public Builder knownGender(Consumer<KnownGender.Builder> knownGender) {
            return this.knownGender((KnownGender)((KnownGender.Builder)KnownGender.builder().applyMutation(knownGender)).build());
        }
    }
}

