/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.SegmentType;
import software.amazon.awssdk.services.rekognition.model.ShotSegment;
import software.amazon.awssdk.services.rekognition.model.TechnicalCueSegment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SegmentDetection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SegmentDetection> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(SegmentDetection.getter(SegmentDetection::typeAsString)).setter(SegmentDetection.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Long> START_TIMESTAMP_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("StartTimestampMillis").getter(SegmentDetection.getter(SegmentDetection::startTimestampMillis)).setter(SegmentDetection.setter(Builder::startTimestampMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestampMillis").build()}).build();
    private static final SdkField<Long> END_TIMESTAMP_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EndTimestampMillis").getter(SegmentDetection.getter(SegmentDetection::endTimestampMillis)).setter(SegmentDetection.setter(Builder::endTimestampMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestampMillis").build()}).build();
    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DurationMillis").getter(SegmentDetection.getter(SegmentDetection::durationMillis)).setter(SegmentDetection.setter(Builder::durationMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()}).build();
    private static final SdkField<String> START_TIMECODE_SMPTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartTimecodeSMPTE").getter(SegmentDetection.getter(SegmentDetection::startTimecodeSMPTE)).setter(SegmentDetection.setter(Builder::startTimecodeSMPTE)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimecodeSMPTE").build()}).build();
    private static final SdkField<String> END_TIMECODE_SMPTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndTimecodeSMPTE").getter(SegmentDetection.getter(SegmentDetection::endTimecodeSMPTE)).setter(SegmentDetection.setter(Builder::endTimecodeSMPTE)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimecodeSMPTE").build()}).build();
    private static final SdkField<String> DURATION_SMPTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DurationSMPTE").getter(SegmentDetection.getter(SegmentDetection::durationSMPTE)).setter(SegmentDetection.setter(Builder::durationSMPTE)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSMPTE").build()}).build();
    private static final SdkField<TechnicalCueSegment> TECHNICAL_CUE_SEGMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TechnicalCueSegment").getter(SegmentDetection.getter(SegmentDetection::technicalCueSegment)).setter(SegmentDetection.setter(Builder::technicalCueSegment)).constructor(TechnicalCueSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TechnicalCueSegment").build()}).build();
    private static final SdkField<ShotSegment> SHOT_SEGMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShotSegment").getter(SegmentDetection.getter(SegmentDetection::shotSegment)).setter(SegmentDetection.setter(Builder::shotSegment)).constructor(ShotSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShotSegment").build()}).build();
    private static final SdkField<Long> START_FRAME_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("StartFrameNumber").getter(SegmentDetection.getter(SegmentDetection::startFrameNumber)).setter(SegmentDetection.setter(Builder::startFrameNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartFrameNumber").build()}).build();
    private static final SdkField<Long> END_FRAME_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EndFrameNumber").getter(SegmentDetection.getter(SegmentDetection::endFrameNumber)).setter(SegmentDetection.setter(Builder::endFrameNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndFrameNumber").build()}).build();
    private static final SdkField<Long> DURATION_FRAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DurationFrames").getter(SegmentDetection.getter(SegmentDetection::durationFrames)).setter(SegmentDetection.setter(Builder::durationFrames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationFrames").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, START_TIMESTAMP_MILLIS_FIELD, END_TIMESTAMP_MILLIS_FIELD, DURATION_MILLIS_FIELD, START_TIMECODE_SMPTE_FIELD, END_TIMECODE_SMPTE_FIELD, DURATION_SMPTE_FIELD, TECHNICAL_CUE_SEGMENT_FIELD, SHOT_SEGMENT_FIELD, START_FRAME_NUMBER_FIELD, END_FRAME_NUMBER_FIELD, DURATION_FRAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SegmentDetection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Long startTimestampMillis;
    private final Long endTimestampMillis;
    private final Long durationMillis;
    private final String startTimecodeSMPTE;
    private final String endTimecodeSMPTE;
    private final String durationSMPTE;
    private final TechnicalCueSegment technicalCueSegment;
    private final ShotSegment shotSegment;
    private final Long startFrameNumber;
    private final Long endFrameNumber;
    private final Long durationFrames;

    private SegmentDetection(BuilderImpl builder) {
        this.type = builder.type;
        this.startTimestampMillis = builder.startTimestampMillis;
        this.endTimestampMillis = builder.endTimestampMillis;
        this.durationMillis = builder.durationMillis;
        this.startTimecodeSMPTE = builder.startTimecodeSMPTE;
        this.endTimecodeSMPTE = builder.endTimecodeSMPTE;
        this.durationSMPTE = builder.durationSMPTE;
        this.technicalCueSegment = builder.technicalCueSegment;
        this.shotSegment = builder.shotSegment;
        this.startFrameNumber = builder.startFrameNumber;
        this.endFrameNumber = builder.endFrameNumber;
        this.durationFrames = builder.durationFrames;
    }

    public final SegmentType type() {
        return SegmentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Long startTimestampMillis() {
        return this.startTimestampMillis;
    }

    public final Long endTimestampMillis() {
        return this.endTimestampMillis;
    }

    public final Long durationMillis() {
        return this.durationMillis;
    }

    public final String startTimecodeSMPTE() {
        return this.startTimecodeSMPTE;
    }

    public final String endTimecodeSMPTE() {
        return this.endTimecodeSMPTE;
    }

    public final String durationSMPTE() {
        return this.durationSMPTE;
    }

    public final TechnicalCueSegment technicalCueSegment() {
        return this.technicalCueSegment;
    }

    public final ShotSegment shotSegment() {
        return this.shotSegment;
    }

    public final Long startFrameNumber() {
        return this.startFrameNumber;
    }

    public final Long endFrameNumber() {
        return this.endFrameNumber;
    }

    public final Long durationFrames() {
        return this.durationFrames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestampMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimestampMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimecodeSMPTE());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimecodeSMPTE());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSMPTE());
        hashCode = 31 * hashCode + Objects.hashCode(this.technicalCueSegment());
        hashCode = 31 * hashCode + Objects.hashCode(this.shotSegment());
        hashCode = 31 * hashCode + Objects.hashCode(this.startFrameNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.endFrameNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationFrames());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentDetection)) {
            return false;
        }
        SegmentDetection other = (SegmentDetection)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.startTimestampMillis(), other.startTimestampMillis()) && Objects.equals(this.endTimestampMillis(), other.endTimestampMillis()) && Objects.equals(this.durationMillis(), other.durationMillis()) && Objects.equals(this.startTimecodeSMPTE(), other.startTimecodeSMPTE()) && Objects.equals(this.endTimecodeSMPTE(), other.endTimecodeSMPTE()) && Objects.equals(this.durationSMPTE(), other.durationSMPTE()) && Objects.equals(this.technicalCueSegment(), other.technicalCueSegment()) && Objects.equals(this.shotSegment(), other.shotSegment()) && Objects.equals(this.startFrameNumber(), other.startFrameNumber()) && Objects.equals(this.endFrameNumber(), other.endFrameNumber()) && Objects.equals(this.durationFrames(), other.durationFrames());
    }

    public final String toString() {
        return ToString.builder((String)"SegmentDetection").add("Type", (Object)this.typeAsString()).add("StartTimestampMillis", (Object)this.startTimestampMillis()).add("EndTimestampMillis", (Object)this.endTimestampMillis()).add("DurationMillis", (Object)this.durationMillis()).add("StartTimecodeSMPTE", (Object)this.startTimecodeSMPTE()).add("EndTimecodeSMPTE", (Object)this.endTimecodeSMPTE()).add("DurationSMPTE", (Object)this.durationSMPTE()).add("TechnicalCueSegment", (Object)this.technicalCueSegment()).add("ShotSegment", (Object)this.shotSegment()).add("StartFrameNumber", (Object)this.startFrameNumber()).add("EndFrameNumber", (Object)this.endFrameNumber()).add("DurationFrames", (Object)this.durationFrames()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "StartTimestampMillis": {
                return Optional.ofNullable(clazz.cast(this.startTimestampMillis()));
            }
            case "EndTimestampMillis": {
                return Optional.ofNullable(clazz.cast(this.endTimestampMillis()));
            }
            case "DurationMillis": {
                return Optional.ofNullable(clazz.cast(this.durationMillis()));
            }
            case "StartTimecodeSMPTE": {
                return Optional.ofNullable(clazz.cast(this.startTimecodeSMPTE()));
            }
            case "EndTimecodeSMPTE": {
                return Optional.ofNullable(clazz.cast(this.endTimecodeSMPTE()));
            }
            case "DurationSMPTE": {
                return Optional.ofNullable(clazz.cast(this.durationSMPTE()));
            }
            case "TechnicalCueSegment": {
                return Optional.ofNullable(clazz.cast(this.technicalCueSegment()));
            }
            case "ShotSegment": {
                return Optional.ofNullable(clazz.cast(this.shotSegment()));
            }
            case "StartFrameNumber": {
                return Optional.ofNullable(clazz.cast(this.startFrameNumber()));
            }
            case "EndFrameNumber": {
                return Optional.ofNullable(clazz.cast(this.endFrameNumber()));
            }
            case "DurationFrames": {
                return Optional.ofNullable(clazz.cast(this.durationFrames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("StartTimestampMillis", START_TIMESTAMP_MILLIS_FIELD);
        map.put("EndTimestampMillis", END_TIMESTAMP_MILLIS_FIELD);
        map.put("DurationMillis", DURATION_MILLIS_FIELD);
        map.put("StartTimecodeSMPTE", START_TIMECODE_SMPTE_FIELD);
        map.put("EndTimecodeSMPTE", END_TIMECODE_SMPTE_FIELD);
        map.put("DurationSMPTE", DURATION_SMPTE_FIELD);
        map.put("TechnicalCueSegment", TECHNICAL_CUE_SEGMENT_FIELD);
        map.put("ShotSegment", SHOT_SEGMENT_FIELD);
        map.put("StartFrameNumber", START_FRAME_NUMBER_FIELD);
        map.put("EndFrameNumber", END_FRAME_NUMBER_FIELD);
        map.put("DurationFrames", DURATION_FRAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SegmentDetection, T> g) {
        return obj -> g.apply((SegmentDetection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Long startTimestampMillis;
        private Long endTimestampMillis;
        private Long durationMillis;
        private String startTimecodeSMPTE;
        private String endTimecodeSMPTE;
        private String durationSMPTE;
        private TechnicalCueSegment technicalCueSegment;
        private ShotSegment shotSegment;
        private Long startFrameNumber;
        private Long endFrameNumber;
        private Long durationFrames;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentDetection model) {
            this.type(model.type);
            this.startTimestampMillis(model.startTimestampMillis);
            this.endTimestampMillis(model.endTimestampMillis);
            this.durationMillis(model.durationMillis);
            this.startTimecodeSMPTE(model.startTimecodeSMPTE);
            this.endTimecodeSMPTE(model.endTimecodeSMPTE);
            this.durationSMPTE(model.durationSMPTE);
            this.technicalCueSegment(model.technicalCueSegment);
            this.shotSegment(model.shotSegment);
            this.startFrameNumber(model.startFrameNumber);
            this.endFrameNumber(model.endFrameNumber);
            this.durationFrames(model.durationFrames);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SegmentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Long getStartTimestampMillis() {
            return this.startTimestampMillis;
        }

        public final void setStartTimestampMillis(Long startTimestampMillis) {
            this.startTimestampMillis = startTimestampMillis;
        }

        @Override
        public final Builder startTimestampMillis(Long startTimestampMillis) {
            this.startTimestampMillis = startTimestampMillis;
            return this;
        }

        public final Long getEndTimestampMillis() {
            return this.endTimestampMillis;
        }

        public final void setEndTimestampMillis(Long endTimestampMillis) {
            this.endTimestampMillis = endTimestampMillis;
        }

        @Override
        public final Builder endTimestampMillis(Long endTimestampMillis) {
            this.endTimestampMillis = endTimestampMillis;
            return this;
        }

        public final Long getDurationMillis() {
            return this.durationMillis;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final String getStartTimecodeSMPTE() {
            return this.startTimecodeSMPTE;
        }

        public final void setStartTimecodeSMPTE(String startTimecodeSMPTE) {
            this.startTimecodeSMPTE = startTimecodeSMPTE;
        }

        @Override
        public final Builder startTimecodeSMPTE(String startTimecodeSMPTE) {
            this.startTimecodeSMPTE = startTimecodeSMPTE;
            return this;
        }

        public final String getEndTimecodeSMPTE() {
            return this.endTimecodeSMPTE;
        }

        public final void setEndTimecodeSMPTE(String endTimecodeSMPTE) {
            this.endTimecodeSMPTE = endTimecodeSMPTE;
        }

        @Override
        public final Builder endTimecodeSMPTE(String endTimecodeSMPTE) {
            this.endTimecodeSMPTE = endTimecodeSMPTE;
            return this;
        }

        public final String getDurationSMPTE() {
            return this.durationSMPTE;
        }

        public final void setDurationSMPTE(String durationSMPTE) {
            this.durationSMPTE = durationSMPTE;
        }

        @Override
        public final Builder durationSMPTE(String durationSMPTE) {
            this.durationSMPTE = durationSMPTE;
            return this;
        }

        public final TechnicalCueSegment.Builder getTechnicalCueSegment() {
            return this.technicalCueSegment != null ? this.technicalCueSegment.toBuilder() : null;
        }

        public final void setTechnicalCueSegment(TechnicalCueSegment.BuilderImpl technicalCueSegment) {
            this.technicalCueSegment = technicalCueSegment != null ? technicalCueSegment.build() : null;
        }

        @Override
        public final Builder technicalCueSegment(TechnicalCueSegment technicalCueSegment) {
            this.technicalCueSegment = technicalCueSegment;
            return this;
        }

        public final ShotSegment.Builder getShotSegment() {
            return this.shotSegment != null ? this.shotSegment.toBuilder() : null;
        }

        public final void setShotSegment(ShotSegment.BuilderImpl shotSegment) {
            this.shotSegment = shotSegment != null ? shotSegment.build() : null;
        }

        @Override
        public final Builder shotSegment(ShotSegment shotSegment) {
            this.shotSegment = shotSegment;
            return this;
        }

        public final Long getStartFrameNumber() {
            return this.startFrameNumber;
        }

        public final void setStartFrameNumber(Long startFrameNumber) {
            this.startFrameNumber = startFrameNumber;
        }

        @Override
        public final Builder startFrameNumber(Long startFrameNumber) {
            this.startFrameNumber = startFrameNumber;
            return this;
        }

        public final Long getEndFrameNumber() {
            return this.endFrameNumber;
        }

        public final void setEndFrameNumber(Long endFrameNumber) {
            this.endFrameNumber = endFrameNumber;
        }

        @Override
        public final Builder endFrameNumber(Long endFrameNumber) {
            this.endFrameNumber = endFrameNumber;
            return this;
        }

        public final Long getDurationFrames() {
            return this.durationFrames;
        }

        public final void setDurationFrames(Long durationFrames) {
            this.durationFrames = durationFrames;
        }

        @Override
        public final Builder durationFrames(Long durationFrames) {
            this.durationFrames = durationFrames;
            return this;
        }

        public SegmentDetection build() {
            return new SegmentDetection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SegmentDetection> {
        public Builder type(String var1);

        public Builder type(SegmentType var1);

        public Builder startTimestampMillis(Long var1);

        public Builder endTimestampMillis(Long var1);

        public Builder durationMillis(Long var1);

        public Builder startTimecodeSMPTE(String var1);

        public Builder endTimecodeSMPTE(String var1);

        public Builder durationSMPTE(String var1);

        public Builder technicalCueSegment(TechnicalCueSegment var1);

        default public Builder technicalCueSegment(Consumer<TechnicalCueSegment.Builder> technicalCueSegment) {
            return this.technicalCueSegment((TechnicalCueSegment)((TechnicalCueSegment.Builder)TechnicalCueSegment.builder().applyMutation(technicalCueSegment)).build());
        }

        public Builder shotSegment(ShotSegment var1);

        default public Builder shotSegment(Consumer<ShotSegment.Builder> shotSegment) {
            return this.shotSegment((ShotSegment)((ShotSegment.Builder)ShotSegment.builder().applyMutation(shotSegment)).build());
        }

        public Builder startFrameNumber(Long var1);

        public Builder endFrameNumber(Long var1);

        public Builder durationFrames(Long var1);
    }
}

