/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.FaceIdListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletion;
import software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFacesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DeleteFacesResponse> {
    private static final SdkField<List<String>> DELETED_FACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeletedFaces").getter(DeleteFacesResponse.getter(DeleteFacesResponse::deletedFaces)).setter(DeleteFacesResponse.setter(Builder::deletedFaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletedFaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnsuccessfulFaceDeletion>> UNSUCCESSFUL_FACE_DELETIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnsuccessfulFaceDeletions").getter(DeleteFacesResponse.getter(DeleteFacesResponse::unsuccessfulFaceDeletions)).setter(DeleteFacesResponse.setter(Builder::unsuccessfulFaceDeletions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsuccessfulFaceDeletions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnsuccessfulFaceDeletion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETED_FACES_FIELD, UNSUCCESSFUL_FACE_DELETIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DeletedFaces", DELETED_FACES_FIELD);
            this.put("UnsuccessfulFaceDeletions", UNSUCCESSFUL_FACE_DELETIONS_FIELD);
        }
    });
    private final List<String> deletedFaces;
    private final List<UnsuccessfulFaceDeletion> unsuccessfulFaceDeletions;

    private DeleteFacesResponse(BuilderImpl builder) {
        super(builder);
        this.deletedFaces = builder.deletedFaces;
        this.unsuccessfulFaceDeletions = builder.unsuccessfulFaceDeletions;
    }

    public final boolean hasDeletedFaces() {
        return this.deletedFaces != null && !(this.deletedFaces instanceof SdkAutoConstructList);
    }

    public final List<String> deletedFaces() {
        return this.deletedFaces;
    }

    public final boolean hasUnsuccessfulFaceDeletions() {
        return this.unsuccessfulFaceDeletions != null && !(this.unsuccessfulFaceDeletions instanceof SdkAutoConstructList);
    }

    public final List<UnsuccessfulFaceDeletion> unsuccessfulFaceDeletions() {
        return this.unsuccessfulFaceDeletions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeletedFaces() ? this.deletedFaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnsuccessfulFaceDeletions() ? this.unsuccessfulFaceDeletions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFacesResponse)) {
            return false;
        }
        DeleteFacesResponse other = (DeleteFacesResponse)((Object)obj);
        return this.hasDeletedFaces() == other.hasDeletedFaces() && Objects.equals(this.deletedFaces(), other.deletedFaces()) && this.hasUnsuccessfulFaceDeletions() == other.hasUnsuccessfulFaceDeletions() && Objects.equals(this.unsuccessfulFaceDeletions(), other.unsuccessfulFaceDeletions());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteFacesResponse").add("DeletedFaces", this.hasDeletedFaces() ? this.deletedFaces() : null).add("UnsuccessfulFaceDeletions", this.hasUnsuccessfulFaceDeletions() ? this.unsuccessfulFaceDeletions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeletedFaces": {
                return Optional.ofNullable(clazz.cast(this.deletedFaces()));
            }
            case "UnsuccessfulFaceDeletions": {
                return Optional.ofNullable(clazz.cast(this.unsuccessfulFaceDeletions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFacesResponse, T> g) {
        return obj -> g.apply((DeleteFacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<String> deletedFaces = DefaultSdkAutoConstructList.getInstance();
        private List<UnsuccessfulFaceDeletion> unsuccessfulFaceDeletions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFacesResponse model) {
            super(model);
            this.deletedFaces(model.deletedFaces);
            this.unsuccessfulFaceDeletions(model.unsuccessfulFaceDeletions);
        }

        public final Collection<String> getDeletedFaces() {
            if (this.deletedFaces instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deletedFaces;
        }

        public final void setDeletedFaces(Collection<String> deletedFaces) {
            this.deletedFaces = FaceIdListCopier.copy(deletedFaces);
        }

        @Override
        public final Builder deletedFaces(Collection<String> deletedFaces) {
            this.deletedFaces = FaceIdListCopier.copy(deletedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedFaces(String ... deletedFaces) {
            this.deletedFaces(Arrays.asList(deletedFaces));
            return this;
        }

        public final List<UnsuccessfulFaceDeletion.Builder> getUnsuccessfulFaceDeletions() {
            List<UnsuccessfulFaceDeletion.Builder> result = UnsuccessfulFaceDeletionsListCopier.copyToBuilder(this.unsuccessfulFaceDeletions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessfulFaceDeletions(Collection<UnsuccessfulFaceDeletion.BuilderImpl> unsuccessfulFaceDeletions) {
            this.unsuccessfulFaceDeletions = UnsuccessfulFaceDeletionsListCopier.copyFromBuilder(unsuccessfulFaceDeletions);
        }

        @Override
        public final Builder unsuccessfulFaceDeletions(Collection<UnsuccessfulFaceDeletion> unsuccessfulFaceDeletions) {
            this.unsuccessfulFaceDeletions = UnsuccessfulFaceDeletionsListCopier.copy(unsuccessfulFaceDeletions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFaceDeletions(UnsuccessfulFaceDeletion ... unsuccessfulFaceDeletions) {
            this.unsuccessfulFaceDeletions(Arrays.asList(unsuccessfulFaceDeletions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFaceDeletions(Consumer<UnsuccessfulFaceDeletion.Builder> ... unsuccessfulFaceDeletions) {
            this.unsuccessfulFaceDeletions(Stream.of(unsuccessfulFaceDeletions).map(c -> (UnsuccessfulFaceDeletion)((UnsuccessfulFaceDeletion.Builder)UnsuccessfulFaceDeletion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeleteFacesResponse build() {
            return new DeleteFacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteFacesResponse> {
        public Builder deletedFaces(Collection<String> var1);

        public Builder deletedFaces(String ... var1);

        public Builder unsuccessfulFaceDeletions(Collection<UnsuccessfulFaceDeletion> var1);

        public Builder unsuccessfulFaceDeletions(UnsuccessfulFaceDeletion ... var1);

        public Builder unsuccessfulFaceDeletions(Consumer<UnsuccessfulFaceDeletion.Builder> ... var1);
    }
}

