/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.KnownGender;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.UrlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCelebrityInfoResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, GetCelebrityInfoResponse> {
    private static final SdkField<List<String>> URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Urls").getter(GetCelebrityInfoResponse.getter(GetCelebrityInfoResponse::urls)).setter(GetCelebrityInfoResponse.setter(Builder::urls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Urls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetCelebrityInfoResponse.getter(GetCelebrityInfoResponse::name)).setter(GetCelebrityInfoResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<KnownGender> KNOWN_GENDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KnownGender").getter(GetCelebrityInfoResponse.getter(GetCelebrityInfoResponse::knownGender)).setter(GetCelebrityInfoResponse.setter(Builder::knownGender)).constructor(KnownGender::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KnownGender").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URLS_FIELD, NAME_FIELD, KNOWN_GENDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCelebrityInfoResponse.memberNameToFieldInitializer();
    private final List<String> urls;
    private final String name;
    private final KnownGender knownGender;

    private GetCelebrityInfoResponse(BuilderImpl builder) {
        super(builder);
        this.urls = builder.urls;
        this.name = builder.name;
        this.knownGender = builder.knownGender;
    }

    public final boolean hasUrls() {
        return this.urls != null && !(this.urls instanceof SdkAutoConstructList);
    }

    public final List<String> urls() {
        return this.urls;
    }

    public final String name() {
        return this.name;
    }

    public final KnownGender knownGender() {
        return this.knownGender;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUrls() ? this.urls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.knownGender());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCelebrityInfoResponse)) {
            return false;
        }
        GetCelebrityInfoResponse other = (GetCelebrityInfoResponse)((Object)obj);
        return this.hasUrls() == other.hasUrls() && Objects.equals(this.urls(), other.urls()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.knownGender(), other.knownGender());
    }

    public final String toString() {
        return ToString.builder((String)"GetCelebrityInfoResponse").add("Urls", this.hasUrls() ? this.urls() : null).add("Name", (Object)this.name()).add("KnownGender", (Object)this.knownGender()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Urls": {
                return Optional.ofNullable(clazz.cast(this.urls()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "KnownGender": {
                return Optional.ofNullable(clazz.cast(this.knownGender()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Urls", URLS_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("KnownGender", KNOWN_GENDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCelebrityInfoResponse, T> g) {
        return obj -> g.apply((GetCelebrityInfoResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<String> urls = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private KnownGender knownGender;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCelebrityInfoResponse model) {
            super(model);
            this.urls(model.urls);
            this.name(model.name);
            this.knownGender(model.knownGender);
        }

        public final Collection<String> getUrls() {
            if (this.urls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.urls;
        }

        public final void setUrls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
        }

        @Override
        public final Builder urls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder urls(String ... urls) {
            this.urls(Arrays.asList(urls));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final KnownGender.Builder getKnownGender() {
            return this.knownGender != null ? this.knownGender.toBuilder() : null;
        }

        public final void setKnownGender(KnownGender.BuilderImpl knownGender) {
            this.knownGender = knownGender != null ? knownGender.build() : null;
        }

        @Override
        public final Builder knownGender(KnownGender knownGender) {
            this.knownGender = knownGender;
            return this;
        }

        @Override
        public GetCelebrityInfoResponse build() {
            return new GetCelebrityInfoResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCelebrityInfoResponse> {
        public Builder urls(Collection<String> var1);

        public Builder urls(String ... var1);

        public Builder name(String var1);

        public Builder knownGender(KnownGender var1);

        default public Builder knownGender(Consumer<KnownGender.Builder> knownGender) {
            return this.knownGender((KnownGender)((KnownGender.Builder)KnownGender.builder().applyMutation(knownGender)).build());
        }
    }
}

