/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.services.rekognition.model.StreamProcessingStartSelector;
import software.amazon.awssdk.services.rekognition.model.StreamProcessingStopSelector;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartStreamProcessorRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, StartStreamProcessorRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StartStreamProcessorRequest.getter(StartStreamProcessorRequest::name)).setter(StartStreamProcessorRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<StreamProcessingStartSelector> START_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StartSelector").getter(StartStreamProcessorRequest.getter(StartStreamProcessorRequest::startSelector)).setter(StartStreamProcessorRequest.setter(Builder::startSelector)).constructor(StreamProcessingStartSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartSelector").build()}).build();
    private static final SdkField<StreamProcessingStopSelector> STOP_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StopSelector").getter(StartStreamProcessorRequest.getter(StartStreamProcessorRequest::stopSelector)).setter(StartStreamProcessorRequest.setter(Builder::stopSelector)).constructor(StreamProcessingStopSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopSelector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, START_SELECTOR_FIELD, STOP_SELECTOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("StartSelector", START_SELECTOR_FIELD);
            this.put("StopSelector", STOP_SELECTOR_FIELD);
        }
    });
    private final String name;
    private final StreamProcessingStartSelector startSelector;
    private final StreamProcessingStopSelector stopSelector;

    private StartStreamProcessorRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.startSelector = builder.startSelector;
        this.stopSelector = builder.stopSelector;
    }

    public final String name() {
        return this.name;
    }

    public final StreamProcessingStartSelector startSelector() {
        return this.startSelector;
    }

    public final StreamProcessingStopSelector stopSelector() {
        return this.stopSelector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.startSelector());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopSelector());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartStreamProcessorRequest)) {
            return false;
        }
        StartStreamProcessorRequest other = (StartStreamProcessorRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.startSelector(), other.startSelector()) && Objects.equals(this.stopSelector(), other.stopSelector());
    }

    public final String toString() {
        return ToString.builder((String)"StartStreamProcessorRequest").add("Name", (Object)this.name()).add("StartSelector", (Object)this.startSelector()).add("StopSelector", (Object)this.stopSelector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "StartSelector": {
                return Optional.ofNullable(clazz.cast(this.startSelector()));
            }
            case "StopSelector": {
                return Optional.ofNullable(clazz.cast(this.stopSelector()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartStreamProcessorRequest, T> g) {
        return obj -> g.apply((StartStreamProcessorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String name;
        private StreamProcessingStartSelector startSelector;
        private StreamProcessingStopSelector stopSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(StartStreamProcessorRequest model) {
            super(model);
            this.name(model.name);
            this.startSelector(model.startSelector);
            this.stopSelector(model.stopSelector);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final StreamProcessingStartSelector.Builder getStartSelector() {
            return this.startSelector != null ? this.startSelector.toBuilder() : null;
        }

        public final void setStartSelector(StreamProcessingStartSelector.BuilderImpl startSelector) {
            this.startSelector = startSelector != null ? startSelector.build() : null;
        }

        @Override
        public final Builder startSelector(StreamProcessingStartSelector startSelector) {
            this.startSelector = startSelector;
            return this;
        }

        public final StreamProcessingStopSelector.Builder getStopSelector() {
            return this.stopSelector != null ? this.stopSelector.toBuilder() : null;
        }

        public final void setStopSelector(StreamProcessingStopSelector.BuilderImpl stopSelector) {
            this.stopSelector = stopSelector != null ? stopSelector.build() : null;
        }

        @Override
        public final Builder stopSelector(StreamProcessingStopSelector stopSelector) {
            this.stopSelector = stopSelector;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartStreamProcessorRequest build() {
            return new StartStreamProcessorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartStreamProcessorRequest> {
        public Builder name(String var1);

        public Builder startSelector(StreamProcessingStartSelector var1);

        default public Builder startSelector(Consumer<StreamProcessingStartSelector.Builder> startSelector) {
            return this.startSelector((StreamProcessingStartSelector)((StreamProcessingStartSelector.Builder)StreamProcessingStartSelector.builder().applyMutation(startSelector)).build());
        }

        public Builder stopSelector(StreamProcessingStopSelector var1);

        default public Builder stopSelector(Consumer<StreamProcessingStopSelector.Builder> stopSelector) {
            return this.stopSelector((StreamProcessingStopSelector)((StreamProcessingStopSelector.Builder)StreamProcessingStopSelector.builder().applyMutation(stopSelector)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

