/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetLabelStats
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetLabelStats> {
    private static final SdkField<Integer> ENTRY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EntryCount").getter(DatasetLabelStats.getter(DatasetLabelStats::entryCount)).setter(DatasetLabelStats.setter(Builder::entryCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntryCount").build()}).build();
    private static final SdkField<Integer> BOUNDING_BOX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BoundingBoxCount").getter(DatasetLabelStats.getter(DatasetLabelStats::boundingBoxCount)).setter(DatasetLabelStats.setter(Builder::boundingBoxCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBoxCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_COUNT_FIELD, BOUNDING_BOX_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EntryCount", ENTRY_COUNT_FIELD);
            this.put("BoundingBoxCount", BOUNDING_BOX_COUNT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer entryCount;
    private final Integer boundingBoxCount;

    private DatasetLabelStats(BuilderImpl builder) {
        this.entryCount = builder.entryCount;
        this.boundingBoxCount = builder.boundingBoxCount;
    }

    public final Integer entryCount() {
        return this.entryCount;
    }

    public final Integer boundingBoxCount() {
        return this.boundingBoxCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entryCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.boundingBoxCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetLabelStats)) {
            return false;
        }
        DatasetLabelStats other = (DatasetLabelStats)obj;
        return Objects.equals(this.entryCount(), other.entryCount()) && Objects.equals(this.boundingBoxCount(), other.boundingBoxCount());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetLabelStats").add("EntryCount", (Object)this.entryCount()).add("BoundingBoxCount", (Object)this.boundingBoxCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntryCount": {
                return Optional.ofNullable(clazz.cast(this.entryCount()));
            }
            case "BoundingBoxCount": {
                return Optional.ofNullable(clazz.cast(this.boundingBoxCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DatasetLabelStats, T> g) {
        return obj -> g.apply((DatasetLabelStats)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer entryCount;
        private Integer boundingBoxCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetLabelStats model) {
            this.entryCount(model.entryCount);
            this.boundingBoxCount(model.boundingBoxCount);
        }

        public final Integer getEntryCount() {
            return this.entryCount;
        }

        public final void setEntryCount(Integer entryCount) {
            this.entryCount = entryCount;
        }

        @Override
        public final Builder entryCount(Integer entryCount) {
            this.entryCount = entryCount;
            return this;
        }

        public final Integer getBoundingBoxCount() {
            return this.boundingBoxCount;
        }

        public final void setBoundingBoxCount(Integer boundingBoxCount) {
            this.boundingBoxCount = boundingBoxCount;
        }

        @Override
        public final Builder boundingBoxCount(Integer boundingBoxCount) {
            this.boundingBoxCount = boundingBoxCount;
            return this;
        }

        public DatasetLabelStats build() {
            return new DatasetLabelStats(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetLabelStats> {
        public Builder entryCount(Integer var1);

        public Builder boundingBoxCount(Integer var1);
    }
}

