/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartProjectVersionRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, StartProjectVersionRequest> {
    private static final SdkField<String> PROJECT_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectVersionArn").getter(StartProjectVersionRequest.getter(StartProjectVersionRequest::projectVersionArn)).setter(StartProjectVersionRequest.setter(Builder::projectVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectVersionArn").build()}).build();
    private static final SdkField<Integer> MIN_INFERENCE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinInferenceUnits").getter(StartProjectVersionRequest.getter(StartProjectVersionRequest::minInferenceUnits)).setter(StartProjectVersionRequest.setter(Builder::minInferenceUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinInferenceUnits").build()}).build();
    private static final SdkField<Integer> MAX_INFERENCE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxInferenceUnits").getter(StartProjectVersionRequest.getter(StartProjectVersionRequest::maxInferenceUnits)).setter(StartProjectVersionRequest.setter(Builder::maxInferenceUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInferenceUnits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_VERSION_ARN_FIELD, MIN_INFERENCE_UNITS_FIELD, MAX_INFERENCE_UNITS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProjectVersionArn", PROJECT_VERSION_ARN_FIELD);
            this.put("MinInferenceUnits", MIN_INFERENCE_UNITS_FIELD);
            this.put("MaxInferenceUnits", MAX_INFERENCE_UNITS_FIELD);
        }
    });
    private final String projectVersionArn;
    private final Integer minInferenceUnits;
    private final Integer maxInferenceUnits;

    private StartProjectVersionRequest(BuilderImpl builder) {
        super(builder);
        this.projectVersionArn = builder.projectVersionArn;
        this.minInferenceUnits = builder.minInferenceUnits;
        this.maxInferenceUnits = builder.maxInferenceUnits;
    }

    public final String projectVersionArn() {
        return this.projectVersionArn;
    }

    public final Integer minInferenceUnits() {
        return this.minInferenceUnits;
    }

    public final Integer maxInferenceUnits() {
        return this.maxInferenceUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.minInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxInferenceUnits());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartProjectVersionRequest)) {
            return false;
        }
        StartProjectVersionRequest other = (StartProjectVersionRequest)((Object)obj);
        return Objects.equals(this.projectVersionArn(), other.projectVersionArn()) && Objects.equals(this.minInferenceUnits(), other.minInferenceUnits()) && Objects.equals(this.maxInferenceUnits(), other.maxInferenceUnits());
    }

    public final String toString() {
        return ToString.builder((String)"StartProjectVersionRequest").add("ProjectVersionArn", (Object)this.projectVersionArn()).add("MinInferenceUnits", (Object)this.minInferenceUnits()).add("MaxInferenceUnits", (Object)this.maxInferenceUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectVersionArn": {
                return Optional.ofNullable(clazz.cast(this.projectVersionArn()));
            }
            case "MinInferenceUnits": {
                return Optional.ofNullable(clazz.cast(this.minInferenceUnits()));
            }
            case "MaxInferenceUnits": {
                return Optional.ofNullable(clazz.cast(this.maxInferenceUnits()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartProjectVersionRequest, T> g) {
        return obj -> g.apply((StartProjectVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String projectVersionArn;
        private Integer minInferenceUnits;
        private Integer maxInferenceUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(StartProjectVersionRequest model) {
            super(model);
            this.projectVersionArn(model.projectVersionArn);
            this.minInferenceUnits(model.minInferenceUnits);
            this.maxInferenceUnits(model.maxInferenceUnits);
        }

        public final String getProjectVersionArn() {
            return this.projectVersionArn;
        }

        public final void setProjectVersionArn(String projectVersionArn) {
            this.projectVersionArn = projectVersionArn;
        }

        @Override
        public final Builder projectVersionArn(String projectVersionArn) {
            this.projectVersionArn = projectVersionArn;
            return this;
        }

        public final Integer getMinInferenceUnits() {
            return this.minInferenceUnits;
        }

        public final void setMinInferenceUnits(Integer minInferenceUnits) {
            this.minInferenceUnits = minInferenceUnits;
        }

        @Override
        public final Builder minInferenceUnits(Integer minInferenceUnits) {
            this.minInferenceUnits = minInferenceUnits;
            return this;
        }

        public final Integer getMaxInferenceUnits() {
            return this.maxInferenceUnits;
        }

        public final void setMaxInferenceUnits(Integer maxInferenceUnits) {
            this.maxInferenceUnits = maxInferenceUnits;
        }

        @Override
        public final Builder maxInferenceUnits(Integer maxInferenceUnits) {
            this.maxInferenceUnits = maxInferenceUnits;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartProjectVersionRequest build() {
            return new StartProjectVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartProjectVersionRequest> {
        public Builder projectVersionArn(String var1);

        public Builder minInferenceUnits(Integer var1);

        public Builder maxInferenceUnits(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

