/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.FaceDetection;
import software.amazon.awssdk.services.rekognition.model.FaceDetectionsCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.Video;
import software.amazon.awssdk.services.rekognition.model.VideoJobStatus;
import software.amazon.awssdk.services.rekognition.model.VideoMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFaceDetectionResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, GetFaceDetectionResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(GetFaceDetectionResponse.getter(GetFaceDetectionResponse::jobStatusAsString)).setter(GetFaceDetectionResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(GetFaceDetectionResponse.getter(GetFaceDetectionResponse::statusMessage)).setter(GetFaceDetectionResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<VideoMetadata> VIDEO_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VideoMetadata").getter(GetFaceDetectionResponse.getter(GetFaceDetectionResponse::videoMetadata)).setter(GetFaceDetectionResponse.setter(Builder::videoMetadata)).constructor(VideoMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoMetadata").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetFaceDetectionResponse.getter(GetFaceDetectionResponse::nextToken)).setter(GetFaceDetectionResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<FaceDetection>> FACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Faces").getter(GetFaceDetectionResponse.getter(GetFaceDetectionResponse::faces)).setter(GetFaceDetectionResponse.setter(Builder::faces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Faces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FaceDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(GetFaceDetectionResponse.getter(GetFaceDetectionResponse::jobId)).setter(GetFaceDetectionResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<Video> VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Video").getter(GetFaceDetectionResponse.getter(GetFaceDetectionResponse::video)).setter(GetFaceDetectionResponse.setter(Builder::video)).constructor(Video::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()}).build();
    private static final SdkField<String> JOB_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobTag").getter(GetFaceDetectionResponse.getter(GetFaceDetectionResponse::jobTag)).setter(GetFaceDetectionResponse.setter(Builder::jobTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD, STATUS_MESSAGE_FIELD, VIDEO_METADATA_FIELD, NEXT_TOKEN_FIELD, FACES_FIELD, JOB_ID_FIELD, VIDEO_FIELD, JOB_TAG_FIELD));
    private final String jobStatus;
    private final String statusMessage;
    private final VideoMetadata videoMetadata;
    private final String nextToken;
    private final List<FaceDetection> faces;
    private final String jobId;
    private final Video video;
    private final String jobTag;

    private GetFaceDetectionResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.statusMessage = builder.statusMessage;
        this.videoMetadata = builder.videoMetadata;
        this.nextToken = builder.nextToken;
        this.faces = builder.faces;
        this.jobId = builder.jobId;
        this.video = builder.video;
        this.jobTag = builder.jobTag;
    }

    public final VideoJobStatus jobStatus() {
        return VideoJobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final VideoMetadata videoMetadata() {
        return this.videoMetadata;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFaces() {
        return this.faces != null && !(this.faces instanceof SdkAutoConstructList);
    }

    public final List<FaceDetection> faces() {
        return this.faces;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final Video video() {
        return this.video;
    }

    public final String jobTag() {
        return this.jobTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFaces() ? this.faces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.video());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFaceDetectionResponse)) {
            return false;
        }
        GetFaceDetectionResponse other = (GetFaceDetectionResponse)((Object)obj);
        return Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.videoMetadata(), other.videoMetadata()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasFaces() == other.hasFaces() && Objects.equals(this.faces(), other.faces()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.video(), other.video()) && Objects.equals(this.jobTag(), other.jobTag());
    }

    public final String toString() {
        return ToString.builder((String)"GetFaceDetectionResponse").add("JobStatus", (Object)this.jobStatusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("VideoMetadata", (Object)this.videoMetadata()).add("NextToken", (Object)this.nextToken()).add("Faces", this.hasFaces() ? this.faces() : null).add("JobId", (Object)this.jobId()).add("Video", (Object)this.video()).add("JobTag", (Object)this.jobTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "VideoMetadata": {
                return Optional.ofNullable(clazz.cast(this.videoMetadata()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Faces": {
                return Optional.ofNullable(clazz.cast(this.faces()));
            }
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "Video": {
                return Optional.ofNullable(clazz.cast(this.video()));
            }
            case "JobTag": {
                return Optional.ofNullable(clazz.cast(this.jobTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFaceDetectionResponse, T> g) {
        return obj -> g.apply((GetFaceDetectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private String jobStatus;
        private String statusMessage;
        private VideoMetadata videoMetadata;
        private String nextToken;
        private List<FaceDetection> faces = DefaultSdkAutoConstructList.getInstance();
        private String jobId;
        private Video video;
        private String jobTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFaceDetectionResponse model) {
            super(model);
            this.jobStatus(model.jobStatus);
            this.statusMessage(model.statusMessage);
            this.videoMetadata(model.videoMetadata);
            this.nextToken(model.nextToken);
            this.faces(model.faces);
            this.jobId(model.jobId);
            this.video(model.video);
            this.jobTag(model.jobTag);
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(VideoJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final VideoMetadata.Builder getVideoMetadata() {
            return this.videoMetadata != null ? this.videoMetadata.toBuilder() : null;
        }

        public final void setVideoMetadata(VideoMetadata.BuilderImpl videoMetadata) {
            this.videoMetadata = videoMetadata != null ? videoMetadata.build() : null;
        }

        @Override
        public final Builder videoMetadata(VideoMetadata videoMetadata) {
            this.videoMetadata = videoMetadata;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<FaceDetection.Builder> getFaces() {
            List<FaceDetection.Builder> result = FaceDetectionsCopier.copyToBuilder(this.faces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFaces(Collection<FaceDetection.BuilderImpl> faces) {
            this.faces = FaceDetectionsCopier.copyFromBuilder(faces);
        }

        @Override
        public final Builder faces(Collection<FaceDetection> faces) {
            this.faces = FaceDetectionsCopier.copy(faces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faces(FaceDetection ... faces) {
            this.faces(Arrays.asList(faces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faces(Consumer<FaceDetection.Builder> ... faces) {
            this.faces(Stream.of(faces).map(c -> (FaceDetection)((FaceDetection.Builder)FaceDetection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Video.Builder getVideo() {
            return this.video != null ? this.video.toBuilder() : null;
        }

        public final void setVideo(Video.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(Video video) {
            this.video = video;
            return this;
        }

        public final String getJobTag() {
            return this.jobTag;
        }

        public final void setJobTag(String jobTag) {
            this.jobTag = jobTag;
        }

        @Override
        public final Builder jobTag(String jobTag) {
            this.jobTag = jobTag;
            return this;
        }

        @Override
        public GetFaceDetectionResponse build() {
            return new GetFaceDetectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFaceDetectionResponse> {
        public Builder jobStatus(String var1);

        public Builder jobStatus(VideoJobStatus var1);

        public Builder statusMessage(String var1);

        public Builder videoMetadata(VideoMetadata var1);

        default public Builder videoMetadata(Consumer<VideoMetadata.Builder> videoMetadata) {
            return this.videoMetadata((VideoMetadata)((VideoMetadata.Builder)VideoMetadata.builder().applyMutation(videoMetadata)).build());
        }

        public Builder nextToken(String var1);

        public Builder faces(Collection<FaceDetection> var1);

        public Builder faces(FaceDetection ... var1);

        public Builder faces(Consumer<FaceDetection.Builder> ... var1);

        public Builder jobId(String var1);

        public Builder video(Video var1);

        default public Builder video(Consumer<Video.Builder> video) {
            return this.video((Video)((Video.Builder)Video.builder().applyMutation(video)).build());
        }

        public Builder jobTag(String var1);
    }
}

