/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.internal.UserAgentUtils;
import software.amazon.awssdk.services.rekognition.model.ListMediaAnalysisJobsRequest;
import software.amazon.awssdk.services.rekognition.model.ListMediaAnalysisJobsResponse;

public class ListMediaAnalysisJobsPublisher
implements SdkPublisher<ListMediaAnalysisJobsResponse> {
    private final RekognitionAsyncClient client;
    private final ListMediaAnalysisJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMediaAnalysisJobsPublisher(RekognitionAsyncClient client, ListMediaAnalysisJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMediaAnalysisJobsPublisher(RekognitionAsyncClient client, ListMediaAnalysisJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMediaAnalysisJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMediaAnalysisJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMediaAnalysisJobsResponseFetcher
    implements AsyncPageFetcher<ListMediaAnalysisJobsResponse> {
        private ListMediaAnalysisJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListMediaAnalysisJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMediaAnalysisJobsResponse> nextPage(ListMediaAnalysisJobsResponse previousPage) {
            if (previousPage == null) {
                return ListMediaAnalysisJobsPublisher.this.client.listMediaAnalysisJobs(ListMediaAnalysisJobsPublisher.this.firstRequest);
            }
            return ListMediaAnalysisJobsPublisher.this.client.listMediaAnalysisJobs((ListMediaAnalysisJobsRequest)((Object)ListMediaAnalysisJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

