/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.SearchedFaceDetails;
import software.amazon.awssdk.services.rekognition.model.UnsearchedFace;
import software.amazon.awssdk.services.rekognition.model.UnsearchedFacesListCopier;
import software.amazon.awssdk.services.rekognition.model.UserMatch;
import software.amazon.awssdk.services.rekognition.model.UserMatchListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchUsersByImageResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, SearchUsersByImageResponse> {
    private static final SdkField<List<UserMatch>> USER_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserMatches").getter(SearchUsersByImageResponse.getter(SearchUsersByImageResponse::userMatches)).setter(SearchUsersByImageResponse.setter(Builder::userMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FACE_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FaceModelVersion").getter(SearchUsersByImageResponse.getter(SearchUsersByImageResponse::faceModelVersion)).setter(SearchUsersByImageResponse.setter(Builder::faceModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceModelVersion").build()}).build();
    private static final SdkField<SearchedFaceDetails> SEARCHED_FACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SearchedFace").getter(SearchUsersByImageResponse.getter(SearchUsersByImageResponse::searchedFace)).setter(SearchUsersByImageResponse.setter(Builder::searchedFace)).constructor(SearchedFaceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchedFace").build()}).build();
    private static final SdkField<List<UnsearchedFace>> UNSEARCHED_FACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnsearchedFaces").getter(SearchUsersByImageResponse.getter(SearchUsersByImageResponse::unsearchedFaces)).setter(SearchUsersByImageResponse.setter(Builder::unsearchedFaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsearchedFaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnsearchedFace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_MATCHES_FIELD, FACE_MODEL_VERSION_FIELD, SEARCHED_FACE_FIELD, UNSEARCHED_FACES_FIELD));
    private final List<UserMatch> userMatches;
    private final String faceModelVersion;
    private final SearchedFaceDetails searchedFace;
    private final List<UnsearchedFace> unsearchedFaces;

    private SearchUsersByImageResponse(BuilderImpl builder) {
        super(builder);
        this.userMatches = builder.userMatches;
        this.faceModelVersion = builder.faceModelVersion;
        this.searchedFace = builder.searchedFace;
        this.unsearchedFaces = builder.unsearchedFaces;
    }

    public final boolean hasUserMatches() {
        return this.userMatches != null && !(this.userMatches instanceof SdkAutoConstructList);
    }

    public final List<UserMatch> userMatches() {
        return this.userMatches;
    }

    public final String faceModelVersion() {
        return this.faceModelVersion;
    }

    public final SearchedFaceDetails searchedFace() {
        return this.searchedFace;
    }

    public final boolean hasUnsearchedFaces() {
        return this.unsearchedFaces != null && !(this.unsearchedFaces instanceof SdkAutoConstructList);
    }

    public final List<UnsearchedFace> unsearchedFaces() {
        return this.unsearchedFaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserMatches() ? this.userMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.faceModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchedFace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnsearchedFaces() ? this.unsearchedFaces() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchUsersByImageResponse)) {
            return false;
        }
        SearchUsersByImageResponse other = (SearchUsersByImageResponse)((Object)obj);
        return this.hasUserMatches() == other.hasUserMatches() && Objects.equals(this.userMatches(), other.userMatches()) && Objects.equals(this.faceModelVersion(), other.faceModelVersion()) && Objects.equals(this.searchedFace(), other.searchedFace()) && this.hasUnsearchedFaces() == other.hasUnsearchedFaces() && Objects.equals(this.unsearchedFaces(), other.unsearchedFaces());
    }

    public final String toString() {
        return ToString.builder((String)"SearchUsersByImageResponse").add("UserMatches", this.hasUserMatches() ? this.userMatches() : null).add("FaceModelVersion", (Object)this.faceModelVersion()).add("SearchedFace", (Object)this.searchedFace()).add("UnsearchedFaces", this.hasUnsearchedFaces() ? this.unsearchedFaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserMatches": {
                return Optional.ofNullable(clazz.cast(this.userMatches()));
            }
            case "FaceModelVersion": {
                return Optional.ofNullable(clazz.cast(this.faceModelVersion()));
            }
            case "SearchedFace": {
                return Optional.ofNullable(clazz.cast(this.searchedFace()));
            }
            case "UnsearchedFaces": {
                return Optional.ofNullable(clazz.cast(this.unsearchedFaces()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchUsersByImageResponse, T> g) {
        return obj -> g.apply((SearchUsersByImageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<UserMatch> userMatches = DefaultSdkAutoConstructList.getInstance();
        private String faceModelVersion;
        private SearchedFaceDetails searchedFace;
        private List<UnsearchedFace> unsearchedFaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchUsersByImageResponse model) {
            super(model);
            this.userMatches(model.userMatches);
            this.faceModelVersion(model.faceModelVersion);
            this.searchedFace(model.searchedFace);
            this.unsearchedFaces(model.unsearchedFaces);
        }

        public final List<UserMatch.Builder> getUserMatches() {
            List<UserMatch.Builder> result = UserMatchListCopier.copyToBuilder(this.userMatches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserMatches(Collection<UserMatch.BuilderImpl> userMatches) {
            this.userMatches = UserMatchListCopier.copyFromBuilder(userMatches);
        }

        @Override
        public final Builder userMatches(Collection<UserMatch> userMatches) {
            this.userMatches = UserMatchListCopier.copy(userMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userMatches(UserMatch ... userMatches) {
            this.userMatches(Arrays.asList(userMatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userMatches(Consumer<UserMatch.Builder> ... userMatches) {
            this.userMatches(Stream.of(userMatches).map(c -> (UserMatch)((UserMatch.Builder)UserMatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFaceModelVersion() {
            return this.faceModelVersion;
        }

        public final void setFaceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
        }

        @Override
        public final Builder faceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
            return this;
        }

        public final SearchedFaceDetails.Builder getSearchedFace() {
            return this.searchedFace != null ? this.searchedFace.toBuilder() : null;
        }

        public final void setSearchedFace(SearchedFaceDetails.BuilderImpl searchedFace) {
            this.searchedFace = searchedFace != null ? searchedFace.build() : null;
        }

        @Override
        public final Builder searchedFace(SearchedFaceDetails searchedFace) {
            this.searchedFace = searchedFace;
            return this;
        }

        public final List<UnsearchedFace.Builder> getUnsearchedFaces() {
            List<UnsearchedFace.Builder> result = UnsearchedFacesListCopier.copyToBuilder(this.unsearchedFaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsearchedFaces(Collection<UnsearchedFace.BuilderImpl> unsearchedFaces) {
            this.unsearchedFaces = UnsearchedFacesListCopier.copyFromBuilder(unsearchedFaces);
        }

        @Override
        public final Builder unsearchedFaces(Collection<UnsearchedFace> unsearchedFaces) {
            this.unsearchedFaces = UnsearchedFacesListCopier.copy(unsearchedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsearchedFaces(UnsearchedFace ... unsearchedFaces) {
            this.unsearchedFaces(Arrays.asList(unsearchedFaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsearchedFaces(Consumer<UnsearchedFace.Builder> ... unsearchedFaces) {
            this.unsearchedFaces(Stream.of(unsearchedFaces).map(c -> (UnsearchedFace)((UnsearchedFace.Builder)UnsearchedFace.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchUsersByImageResponse build() {
            return new SearchUsersByImageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchUsersByImageResponse> {
        public Builder userMatches(Collection<UserMatch> var1);

        public Builder userMatches(UserMatch ... var1);

        public Builder userMatches(Consumer<UserMatch.Builder> ... var1);

        public Builder faceModelVersion(String var1);

        public Builder searchedFace(SearchedFaceDetails var1);

        default public Builder searchedFace(Consumer<SearchedFaceDetails.Builder> searchedFace) {
            return this.searchedFace((SearchedFaceDetails)((SearchedFaceDetails.Builder)SearchedFaceDetails.builder().applyMutation(searchedFace)).build());
        }

        public Builder unsearchedFaces(Collection<UnsearchedFace> var1);

        public Builder unsearchedFaces(UnsearchedFace ... var1);

        public Builder unsearchedFaces(Consumer<UnsearchedFace.Builder> ... var1);
    }
}

