/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rekognition.DefaultRekognitionBaseClientBuilder;
import software.amazon.awssdk.services.rekognition.DefaultRekognitionClient;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.RekognitionClientBuilder;
import software.amazon.awssdk.services.rekognition.RekognitionServiceClientConfiguration;
import software.amazon.awssdk.services.rekognition.endpoints.RekognitionEndpointProvider;

@SdkInternalApi
final class DefaultRekognitionClientBuilder
extends DefaultRekognitionBaseClientBuilder<RekognitionClientBuilder, RekognitionClient>
implements RekognitionClientBuilder {
    DefaultRekognitionClientBuilder() {
    }

    @Override
    public DefaultRekognitionClientBuilder endpointProvider(RekognitionEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RekognitionClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultRekognitionClientBuilder.validateClientOptions(clientConfiguration);
        RekognitionServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultRekognitionClient client = new DefaultRekognitionClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private RekognitionServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return RekognitionServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

