/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutProjectPolicyRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, PutProjectPolicyRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectArn").getter(PutProjectPolicyRequest.getter(PutProjectPolicyRequest::projectArn)).setter(PutProjectPolicyRequest.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectArn").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(PutProjectPolicyRequest.getter(PutProjectPolicyRequest::policyName)).setter(PutProjectPolicyRequest.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> POLICY_REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyRevisionId").getter(PutProjectPolicyRequest.getter(PutProjectPolicyRequest::policyRevisionId)).setter(PutProjectPolicyRequest.setter(Builder::policyRevisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyRevisionId").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyDocument").getter(PutProjectPolicyRequest.getter(PutProjectPolicyRequest::policyDocument)).setter(PutProjectPolicyRequest.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, POLICY_NAME_FIELD, POLICY_REVISION_ID_FIELD, POLICY_DOCUMENT_FIELD));
    private final String projectArn;
    private final String policyName;
    private final String policyRevisionId;
    private final String policyDocument;

    private PutProjectPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.policyName = builder.policyName;
        this.policyRevisionId = builder.policyRevisionId;
        this.policyDocument = builder.policyDocument;
    }

    public final String projectArn() {
        return this.projectArn;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final String policyRevisionId() {
        return this.policyRevisionId;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyRevisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProjectPolicyRequest)) {
            return false;
        }
        PutProjectPolicyRequest other = (PutProjectPolicyRequest)((Object)obj);
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyRevisionId(), other.policyRevisionId()) && Objects.equals(this.policyDocument(), other.policyDocument());
    }

    public final String toString() {
        return ToString.builder((String)"PutProjectPolicyRequest").add("ProjectArn", (Object)this.projectArn()).add("PolicyName", (Object)this.policyName()).add("PolicyRevisionId", (Object)this.policyRevisionId()).add("PolicyDocument", (Object)this.policyDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "PolicyRevisionId": {
                return Optional.ofNullable(clazz.cast(this.policyRevisionId()));
            }
            case "PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutProjectPolicyRequest, T> g) {
        return obj -> g.apply((PutProjectPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String projectArn;
        private String policyName;
        private String policyRevisionId;
        private String policyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(PutProjectPolicyRequest model) {
            super(model);
            this.projectArn(model.projectArn);
            this.policyName(model.policyName);
            this.policyRevisionId(model.policyRevisionId);
            this.policyDocument(model.policyDocument);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyRevisionId() {
            return this.policyRevisionId;
        }

        public final void setPolicyRevisionId(String policyRevisionId) {
            this.policyRevisionId = policyRevisionId;
        }

        @Override
        public final Builder policyRevisionId(String policyRevisionId) {
            this.policyRevisionId = policyRevisionId;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutProjectPolicyRequest build() {
            return new PutProjectPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutProjectPolicyRequest> {
        public Builder projectArn(String var1);

        public Builder policyName(String var1);

        public Builder policyRevisionId(String var1);

        public Builder policyDocument(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

