/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionResponse;

public class GetSegmentDetectionPublisher
implements SdkPublisher<GetSegmentDetectionResponse> {
    private final RekognitionAsyncClient client;
    private final GetSegmentDetectionRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetSegmentDetectionPublisher(RekognitionAsyncClient client, GetSegmentDetectionRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetSegmentDetectionPublisher(RekognitionAsyncClient client, GetSegmentDetectionRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetSegmentDetectionResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetSegmentDetectionResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetSegmentDetectionResponseFetcher
    implements AsyncPageFetcher<GetSegmentDetectionResponse> {
        private GetSegmentDetectionResponseFetcher() {
        }

        public boolean hasNextPage(GetSegmentDetectionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetSegmentDetectionResponse> nextPage(GetSegmentDetectionResponse previousPage) {
            if (previousPage == null) {
                return GetSegmentDetectionPublisher.this.client.getSegmentDetection(GetSegmentDetectionPublisher.this.firstRequest);
            }
            return GetSegmentDetectionPublisher.this.client.getSegmentDetection((GetSegmentDetectionRequest)((Object)GetSegmentDetectionPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

