/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse;

public class ListCollectionsIterable
implements SdkIterable<ListCollectionsResponse> {
    private final RekognitionClient client;
    private final ListCollectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCollectionsIterable(RekognitionClient client, ListCollectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCollectionsResponseFetcher();
    }

    public Iterator<ListCollectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> collectionIds() {
        Function<ListCollectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collectionIds() != null) {
                return response.collectionIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCollectionsResponseFetcher
    implements SyncPageFetcher<ListCollectionsResponse> {
        private ListCollectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCollectionsResponse nextPage(ListCollectionsResponse previousPage) {
            if (previousPage == null) {
                return ListCollectionsIterable.this.client.listCollections(ListCollectionsIterable.this.firstRequest);
            }
            return ListCollectionsIterable.this.client.listCollections((ListCollectionsRequest)((Object)ListCollectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

