/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsResponse;
import software.amazon.awssdk.services.rekognition.model.ProjectVersionDescription;

public class DescribeProjectVersionsIterable
implements SdkIterable<DescribeProjectVersionsResponse> {
    private final RekognitionClient client;
    private final DescribeProjectVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeProjectVersionsIterable(RekognitionClient client, DescribeProjectVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeProjectVersionsResponseFetcher();
    }

    public Iterator<DescribeProjectVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProjectVersionDescription> projectVersionDescriptions() {
        Function<DescribeProjectVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.projectVersionDescriptions() != null) {
                return response.projectVersionDescriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeProjectVersionsResponseFetcher
    implements SyncPageFetcher<DescribeProjectVersionsResponse> {
        private DescribeProjectVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeProjectVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeProjectVersionsResponse nextPage(DescribeProjectVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeProjectVersionsIterable.this.client.describeProjectVersions(DescribeProjectVersionsIterable.this.firstRequest);
            }
            return DescribeProjectVersionsIterable.this.client.describeProjectVersions((DescribeProjectVersionsRequest)((Object)DescribeProjectVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

