/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummarizationAttributes;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectProtectiveEquipmentRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, DetectProtectiveEquipmentRequest> {
    private static final SdkField<Image> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Image").getter(DetectProtectiveEquipmentRequest.getter(DetectProtectiveEquipmentRequest::image)).setter(DetectProtectiveEquipmentRequest.setter(Builder::image)).constructor(Image::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()}).build();
    private static final SdkField<ProtectiveEquipmentSummarizationAttributes> SUMMARIZATION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SummarizationAttributes").getter(DetectProtectiveEquipmentRequest.getter(DetectProtectiveEquipmentRequest::summarizationAttributes)).setter(DetectProtectiveEquipmentRequest.setter(Builder::summarizationAttributes)).constructor(ProtectiveEquipmentSummarizationAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummarizationAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD, SUMMARIZATION_ATTRIBUTES_FIELD));
    private final Image image;
    private final ProtectiveEquipmentSummarizationAttributes summarizationAttributes;

    private DetectProtectiveEquipmentRequest(BuilderImpl builder) {
        super(builder);
        this.image = builder.image;
        this.summarizationAttributes = builder.summarizationAttributes;
    }

    public Image image() {
        return this.image;
    }

    public ProtectiveEquipmentSummarizationAttributes summarizationAttributes() {
        return this.summarizationAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.summarizationAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectProtectiveEquipmentRequest)) {
            return false;
        }
        DetectProtectiveEquipmentRequest other = (DetectProtectiveEquipmentRequest)((Object)obj);
        return Objects.equals(this.image(), other.image()) && Objects.equals(this.summarizationAttributes(), other.summarizationAttributes());
    }

    public String toString() {
        return ToString.builder((String)"DetectProtectiveEquipmentRequest").add("Image", (Object)this.image()).add("SummarizationAttributes", (Object)this.summarizationAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "SummarizationAttributes": {
                return Optional.ofNullable(clazz.cast(this.summarizationAttributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectProtectiveEquipmentRequest, T> g) {
        return obj -> g.apply((DetectProtectiveEquipmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private Image image;
        private ProtectiveEquipmentSummarizationAttributes summarizationAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectProtectiveEquipmentRequest model) {
            super(model);
            this.image(model.image);
            this.summarizationAttributes(model.summarizationAttributes);
        }

        public final Image.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final ProtectiveEquipmentSummarizationAttributes.Builder getSummarizationAttributes() {
            return this.summarizationAttributes != null ? this.summarizationAttributes.toBuilder() : null;
        }

        @Override
        public final Builder summarizationAttributes(ProtectiveEquipmentSummarizationAttributes summarizationAttributes) {
            this.summarizationAttributes = summarizationAttributes;
            return this;
        }

        public final void setSummarizationAttributes(ProtectiveEquipmentSummarizationAttributes.BuilderImpl summarizationAttributes) {
            this.summarizationAttributes = summarizationAttributes != null ? summarizationAttributes.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectProtectiveEquipmentRequest build() {
            return new DetectProtectiveEquipmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectProtectiveEquipmentRequest> {
        public Builder image(Image var1);

        default public Builder image(Consumer<Image.Builder> image) {
            return this.image((Image)((Image.Builder)Image.builder().applyMutation(image)).build());
        }

        public Builder summarizationAttributes(ProtectiveEquipmentSummarizationAttributes var1);

        default public Builder summarizationAttributes(Consumer<ProtectiveEquipmentSummarizationAttributes.Builder> summarizationAttributes) {
            return this.summarizationAttributes((ProtectiveEquipmentSummarizationAttributes)((ProtectiveEquipmentSummarizationAttributes.Builder)ProtectiveEquipmentSummarizationAttributes.builder().applyMutation(summarizationAttributes)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

