/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.Summary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationResult> {
    private static final SdkField<Float> F1_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("F1Score").getter(EvaluationResult.getter(EvaluationResult::f1Score)).setter(EvaluationResult.setter(Builder::f1Score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("F1Score").build()}).build();
    private static final SdkField<Summary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Summary").getter(EvaluationResult.getter(EvaluationResult::summary)).setter(EvaluationResult.setter(Builder::summary)).constructor(Summary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(F1_SCORE_FIELD, SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Float f1Score;
    private final Summary summary;

    private EvaluationResult(BuilderImpl builder) {
        this.f1Score = builder.f1Score;
        this.summary = builder.summary;
    }

    public Float f1Score() {
        return this.f1Score;
    }

    public Summary summary() {
        return this.summary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.f1Score());
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResult)) {
            return false;
        }
        EvaluationResult other = (EvaluationResult)obj;
        return Objects.equals(this.f1Score(), other.f1Score()) && Objects.equals(this.summary(), other.summary());
    }

    public String toString() {
        return ToString.builder((String)"EvaluationResult").add("F1Score", (Object)this.f1Score()).add("Summary", (Object)this.summary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "F1Score": {
                return Optional.ofNullable(clazz.cast(this.f1Score()));
            }
            case "Summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationResult, T> g) {
        return obj -> g.apply((EvaluationResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float f1Score;
        private Summary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResult model) {
            this.f1Score(model.f1Score);
            this.summary(model.summary);
        }

        public final Float getF1Score() {
            return this.f1Score;
        }

        @Override
        public final Builder f1Score(Float f1Score) {
            this.f1Score = f1Score;
            return this;
        }

        public final void setF1Score(Float f1Score) {
            this.f1Score = f1Score;
        }

        public final Summary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        @Override
        public final Builder summary(Summary summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(Summary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        public EvaluationResult build() {
            return new EvaluationResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationResult> {
        public Builder f1Score(Float var1);

        public Builder summary(Summary var1);

        default public Builder summary(Consumer<Summary.Builder> summary) {
            return this.summary((Summary)((Summary.Builder)Summary.builder().applyMutation(summary)).build());
        }
    }
}

