/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.CustomLabel;
import software.amazon.awssdk.services.rekognition.model.CustomLabelsCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectCustomLabelsResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DetectCustomLabelsResponse> {
    private static final SdkField<List<CustomLabel>> CUSTOM_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomLabels").getter(DetectCustomLabelsResponse.getter(DetectCustomLabelsResponse::customLabels)).setter(DetectCustomLabelsResponse.setter(Builder::customLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomLabel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_LABELS_FIELD));
    private final List<CustomLabel> customLabels;

    private DetectCustomLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.customLabels = builder.customLabels;
    }

    public boolean hasCustomLabels() {
        return this.customLabels != null && !(this.customLabels instanceof SdkAutoConstructList);
    }

    public List<CustomLabel> customLabels() {
        return this.customLabels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomLabels() ? this.customLabels() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectCustomLabelsResponse)) {
            return false;
        }
        DetectCustomLabelsResponse other = (DetectCustomLabelsResponse)((Object)obj);
        return this.hasCustomLabels() == other.hasCustomLabels() && Objects.equals(this.customLabels(), other.customLabels());
    }

    public String toString() {
        return ToString.builder((String)"DetectCustomLabelsResponse").add("CustomLabels", this.hasCustomLabels() ? this.customLabels() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomLabels": {
                return Optional.ofNullable(clazz.cast(this.customLabels()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectCustomLabelsResponse, T> g) {
        return obj -> g.apply((DetectCustomLabelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<CustomLabel> customLabels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectCustomLabelsResponse model) {
            super(model);
            this.customLabels(model.customLabels);
        }

        public final Collection<CustomLabel.Builder> getCustomLabels() {
            if (this.customLabels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customLabels != null ? (Collection)this.customLabels.stream().map(CustomLabel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customLabels(Collection<CustomLabel> customLabels) {
            this.customLabels = CustomLabelsCopier.copy(customLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customLabels(CustomLabel ... customLabels) {
            this.customLabels(Arrays.asList(customLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customLabels(Consumer<CustomLabel.Builder> ... customLabels) {
            this.customLabels(Stream.of(customLabels).map(c -> (CustomLabel)((CustomLabel.Builder)CustomLabel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomLabels(Collection<CustomLabel.BuilderImpl> customLabels) {
            this.customLabels = CustomLabelsCopier.copyFromBuilder(customLabels);
        }

        @Override
        public DetectCustomLabelsResponse build() {
            return new DetectCustomLabelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectCustomLabelsResponse> {
        public Builder customLabels(Collection<CustomLabel> var1);

        public Builder customLabels(CustomLabel ... var1);

        public Builder customLabels(Consumer<CustomLabel.Builder> ... var1);
    }
}

