/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.ModerationLabel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContentModerationDetection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContentModerationDetection> {
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Timestamp").getter(ContentModerationDetection.getter(ContentModerationDetection::timestamp)).setter(ContentModerationDetection.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<ModerationLabel> MODERATION_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModerationLabel").getter(ContentModerationDetection.getter(ContentModerationDetection::moderationLabel)).setter(ContentModerationDetection.setter(Builder::moderationLabel)).constructor(ModerationLabel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModerationLabel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, MODERATION_LABEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long timestamp;
    private final ModerationLabel moderationLabel;

    private ContentModerationDetection(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.moderationLabel = builder.moderationLabel;
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public ModerationLabel moderationLabel() {
        return this.moderationLabel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.moderationLabel());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentModerationDetection)) {
            return false;
        }
        ContentModerationDetection other = (ContentModerationDetection)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.moderationLabel(), other.moderationLabel());
    }

    public String toString() {
        return ToString.builder((String)"ContentModerationDetection").add("Timestamp", (Object)this.timestamp()).add("ModerationLabel", (Object)this.moderationLabel()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "ModerationLabel": {
                return Optional.ofNullable(clazz.cast(this.moderationLabel()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContentModerationDetection, T> g) {
        return obj -> g.apply((ContentModerationDetection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long timestamp;
        private ModerationLabel moderationLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(ContentModerationDetection model) {
            this.timestamp(model.timestamp);
            this.moderationLabel(model.moderationLabel);
        }

        public final Long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final ModerationLabel.Builder getModerationLabel() {
            return this.moderationLabel != null ? this.moderationLabel.toBuilder() : null;
        }

        @Override
        public final Builder moderationLabel(ModerationLabel moderationLabel) {
            this.moderationLabel = moderationLabel;
            return this;
        }

        public final void setModerationLabel(ModerationLabel.BuilderImpl moderationLabel) {
            this.moderationLabel = moderationLabel != null ? moderationLabel.build() : null;
        }

        public ContentModerationDetection build() {
            return new ContentModerationDetection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContentModerationDetection> {
        public Builder timestamp(Long var1);

        public Builder moderationLabel(ModerationLabel var1);

        default public Builder moderationLabel(Consumer<ModerationLabel.Builder> moderationLabel) {
            return this.moderationLabel((ModerationLabel)((ModerationLabel.Builder)ModerationLabel.builder().applyMutation(moderationLabel)).build());
        }
    }
}

