/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.StreamProcessor;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStreamProcessorsResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, ListStreamProcessorsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStreamProcessorsResponse.getter(ListStreamProcessorsResponse::nextToken)).setter(ListStreamProcessorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<StreamProcessor>> STREAM_PROCESSORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StreamProcessors").getter(ListStreamProcessorsResponse.getter(ListStreamProcessorsResponse::streamProcessors)).setter(ListStreamProcessorsResponse.setter(Builder::streamProcessors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamProcessors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamProcessor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, STREAM_PROCESSORS_FIELD));
    private final String nextToken;
    private final List<StreamProcessor> streamProcessors;

    private ListStreamProcessorsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.streamProcessors = builder.streamProcessors;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasStreamProcessors() {
        return this.streamProcessors != null && !(this.streamProcessors instanceof SdkAutoConstructList);
    }

    public List<StreamProcessor> streamProcessors() {
        return this.streamProcessors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamProcessors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamProcessorsResponse)) {
            return false;
        }
        ListStreamProcessorsResponse other = (ListStreamProcessorsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.streamProcessors(), other.streamProcessors());
    }

    public String toString() {
        return ToString.builder((String)"ListStreamProcessorsResponse").add("NextToken", (Object)this.nextToken()).add("StreamProcessors", this.streamProcessors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "StreamProcessors": {
                return Optional.ofNullable(clazz.cast(this.streamProcessors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamProcessorsResponse, T> g) {
        return obj -> g.apply((ListStreamProcessorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<StreamProcessor> streamProcessors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamProcessorsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.streamProcessors(model.streamProcessors);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<StreamProcessor.Builder> getStreamProcessors() {
            return this.streamProcessors != null ? (Collection)this.streamProcessors.stream().map(StreamProcessor::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder streamProcessors(Collection<StreamProcessor> streamProcessors) {
            this.streamProcessors = StreamProcessorListCopier.copy(streamProcessors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamProcessors(StreamProcessor ... streamProcessors) {
            this.streamProcessors(Arrays.asList(streamProcessors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamProcessors(Consumer<StreamProcessor.Builder> ... streamProcessors) {
            this.streamProcessors(Stream.of(streamProcessors).map(c -> (StreamProcessor)((StreamProcessor.Builder)StreamProcessor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStreamProcessors(Collection<StreamProcessor.BuilderImpl> streamProcessors) {
            this.streamProcessors = StreamProcessorListCopier.copyFromBuilder(streamProcessors);
        }

        @Override
        public ListStreamProcessorsResponse build() {
            return new ListStreamProcessorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStreamProcessorsResponse> {
        public Builder nextToken(String var1);

        public Builder streamProcessors(Collection<StreamProcessor> var1);

        public Builder streamProcessors(StreamProcessor ... var1);

        public Builder streamProcessors(Consumer<StreamProcessor.Builder> ... var1);
    }
}

