/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartProjectVersionRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, StartProjectVersionRequest> {
    private static final SdkField<String> PROJECT_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectVersionArn").getter(StartProjectVersionRequest.getter(StartProjectVersionRequest::projectVersionArn)).setter(StartProjectVersionRequest.setter(Builder::projectVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectVersionArn").build()}).build();
    private static final SdkField<Integer> MIN_INFERENCE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinInferenceUnits").getter(StartProjectVersionRequest.getter(StartProjectVersionRequest::minInferenceUnits)).setter(StartProjectVersionRequest.setter(Builder::minInferenceUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinInferenceUnits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_VERSION_ARN_FIELD, MIN_INFERENCE_UNITS_FIELD));
    private final String projectVersionArn;
    private final Integer minInferenceUnits;

    private StartProjectVersionRequest(BuilderImpl builder) {
        super(builder);
        this.projectVersionArn = builder.projectVersionArn;
        this.minInferenceUnits = builder.minInferenceUnits;
    }

    public String projectVersionArn() {
        return this.projectVersionArn;
    }

    public Integer minInferenceUnits() {
        return this.minInferenceUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.minInferenceUnits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartProjectVersionRequest)) {
            return false;
        }
        StartProjectVersionRequest other = (StartProjectVersionRequest)((Object)obj);
        return Objects.equals(this.projectVersionArn(), other.projectVersionArn()) && Objects.equals(this.minInferenceUnits(), other.minInferenceUnits());
    }

    public String toString() {
        return ToString.builder((String)"StartProjectVersionRequest").add("ProjectVersionArn", (Object)this.projectVersionArn()).add("MinInferenceUnits", (Object)this.minInferenceUnits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectVersionArn": {
                return Optional.ofNullable(clazz.cast(this.projectVersionArn()));
            }
            case "MinInferenceUnits": {
                return Optional.ofNullable(clazz.cast(this.minInferenceUnits()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartProjectVersionRequest, T> g) {
        return obj -> g.apply((StartProjectVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String projectVersionArn;
        private Integer minInferenceUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(StartProjectVersionRequest model) {
            super(model);
            this.projectVersionArn(model.projectVersionArn);
            this.minInferenceUnits(model.minInferenceUnits);
        }

        public final String getProjectVersionArn() {
            return this.projectVersionArn;
        }

        @Override
        public final Builder projectVersionArn(String projectVersionArn) {
            this.projectVersionArn = projectVersionArn;
            return this;
        }

        public final void setProjectVersionArn(String projectVersionArn) {
            this.projectVersionArn = projectVersionArn;
        }

        public final Integer getMinInferenceUnits() {
            return this.minInferenceUnits;
        }

        @Override
        public final Builder minInferenceUnits(Integer minInferenceUnits) {
            this.minInferenceUnits = minInferenceUnits;
            return this;
        }

        public final void setMinInferenceUnits(Integer minInferenceUnits) {
            this.minInferenceUnits = minInferenceUnits;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartProjectVersionRequest build() {
            return new StartProjectVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartProjectVersionRequest> {
        public Builder projectVersionArn(String var1);

        public Builder minInferenceUnits(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

