/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.NotificationChannel;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.services.rekognition.model.StartTextDetectionFilters;
import software.amazon.awssdk.services.rekognition.model.Video;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTextDetectionRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, StartTextDetectionRequest> {
    private static final SdkField<Video> VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Video").getter(StartTextDetectionRequest.getter(StartTextDetectionRequest::video)).setter(StartTextDetectionRequest.setter(Builder::video)).constructor(Video::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(StartTextDetectionRequest.getter(StartTextDetectionRequest::clientRequestToken)).setter(StartTextDetectionRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()}).build();
    private static final SdkField<NotificationChannel> NOTIFICATION_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationChannel").getter(StartTextDetectionRequest.getter(StartTextDetectionRequest::notificationChannel)).setter(StartTextDetectionRequest.setter(Builder::notificationChannel)).constructor(NotificationChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationChannel").build()}).build();
    private static final SdkField<String> JOB_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobTag").getter(StartTextDetectionRequest.getter(StartTextDetectionRequest::jobTag)).setter(StartTextDetectionRequest.setter(Builder::jobTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTag").build()}).build();
    private static final SdkField<StartTextDetectionFilters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(StartTextDetectionRequest.getter(StartTextDetectionRequest::filters)).setter(StartTextDetectionRequest.setter(Builder::filters)).constructor(StartTextDetectionFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIDEO_FIELD, CLIENT_REQUEST_TOKEN_FIELD, NOTIFICATION_CHANNEL_FIELD, JOB_TAG_FIELD, FILTERS_FIELD));
    private final Video video;
    private final String clientRequestToken;
    private final NotificationChannel notificationChannel;
    private final String jobTag;
    private final StartTextDetectionFilters filters;

    private StartTextDetectionRequest(BuilderImpl builder) {
        super(builder);
        this.video = builder.video;
        this.clientRequestToken = builder.clientRequestToken;
        this.notificationChannel = builder.notificationChannel;
        this.jobTag = builder.jobTag;
        this.filters = builder.filters;
    }

    public Video video() {
        return this.video;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public NotificationChannel notificationChannel() {
        return this.notificationChannel;
    }

    public String jobTag() {
        return this.jobTag;
    }

    public StartTextDetectionFilters filters() {
        return this.filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.video());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTextDetectionRequest)) {
            return false;
        }
        StartTextDetectionRequest other = (StartTextDetectionRequest)((Object)obj);
        return Objects.equals(this.video(), other.video()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.notificationChannel(), other.notificationChannel()) && Objects.equals(this.jobTag(), other.jobTag()) && Objects.equals(this.filters(), other.filters());
    }

    public String toString() {
        return ToString.builder((String)"StartTextDetectionRequest").add("Video", (Object)this.video()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("NotificationChannel", (Object)this.notificationChannel()).add("JobTag", (Object)this.jobTag()).add("Filters", (Object)this.filters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Video": {
                return Optional.ofNullable(clazz.cast(this.video()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "NotificationChannel": {
                return Optional.ofNullable(clazz.cast(this.notificationChannel()));
            }
            case "JobTag": {
                return Optional.ofNullable(clazz.cast(this.jobTag()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTextDetectionRequest, T> g) {
        return obj -> g.apply((StartTextDetectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private Video video;
        private String clientRequestToken;
        private NotificationChannel notificationChannel;
        private String jobTag;
        private StartTextDetectionFilters filters;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTextDetectionRequest model) {
            super(model);
            this.video(model.video);
            this.clientRequestToken(model.clientRequestToken);
            this.notificationChannel(model.notificationChannel);
            this.jobTag(model.jobTag);
            this.filters(model.filters);
        }

        public final Video.Builder getVideo() {
            return this.video != null ? this.video.toBuilder() : null;
        }

        @Override
        public final Builder video(Video video) {
            this.video = video;
            return this;
        }

        public final void setVideo(Video.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final NotificationChannel.Builder getNotificationChannel() {
            return this.notificationChannel != null ? this.notificationChannel.toBuilder() : null;
        }

        @Override
        public final Builder notificationChannel(NotificationChannel notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public final void setNotificationChannel(NotificationChannel.BuilderImpl notificationChannel) {
            this.notificationChannel = notificationChannel != null ? notificationChannel.build() : null;
        }

        public final String getJobTag() {
            return this.jobTag;
        }

        @Override
        public final Builder jobTag(String jobTag) {
            this.jobTag = jobTag;
            return this;
        }

        public final void setJobTag(String jobTag) {
            this.jobTag = jobTag;
        }

        public final StartTextDetectionFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        @Override
        public final Builder filters(StartTextDetectionFilters filters) {
            this.filters = filters;
            return this;
        }

        public final void setFilters(StartTextDetectionFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTextDetectionRequest build() {
            return new StartTextDetectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartTextDetectionRequest> {
        public Builder video(Video var1);

        default public Builder video(Consumer<Video.Builder> video) {
            return this.video((Video)((Video.Builder)Video.builder().applyMutation(video)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder notificationChannel(NotificationChannel var1);

        default public Builder notificationChannel(Consumer<NotificationChannel.Builder> notificationChannel) {
            return this.notificationChannel((NotificationChannel)((NotificationChannel.Builder)NotificationChannel.builder().applyMutation(notificationChannel)).build());
        }

        public Builder jobTag(String var1);

        public Builder filters(StartTextDetectionFilters var1);

        default public Builder filters(Consumer<StartTextDetectionFilters.Builder> filters) {
            return this.filters((StartTextDetectionFilters)((StartTextDetectionFilters.Builder)StartTextDetectionFilters.builder().applyMutation(filters)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

