/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.BodyPartsCopier;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentBodyPart;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtectiveEquipmentPerson
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtectiveEquipmentPerson> {
    private static final SdkField<List<ProtectiveEquipmentBodyPart>> BODY_PARTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BodyParts").getter(ProtectiveEquipmentPerson.getter(ProtectiveEquipmentPerson::bodyParts)).setter(ProtectiveEquipmentPerson.setter(Builder::bodyParts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BodyParts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProtectiveEquipmentBodyPart::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BoundingBox").getter(ProtectiveEquipmentPerson.getter(ProtectiveEquipmentPerson::boundingBox)).setter(ProtectiveEquipmentPerson.setter(Builder::boundingBox)).constructor(BoundingBox::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(ProtectiveEquipmentPerson.getter(ProtectiveEquipmentPerson::confidence)).setter(ProtectiveEquipmentPerson.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<Integer> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Id").getter(ProtectiveEquipmentPerson.getter(ProtectiveEquipmentPerson::id)).setter(ProtectiveEquipmentPerson.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_PARTS_FIELD, BOUNDING_BOX_FIELD, CONFIDENCE_FIELD, ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ProtectiveEquipmentBodyPart> bodyParts;
    private final BoundingBox boundingBox;
    private final Float confidence;
    private final Integer id;

    private ProtectiveEquipmentPerson(BuilderImpl builder) {
        this.bodyParts = builder.bodyParts;
        this.boundingBox = builder.boundingBox;
        this.confidence = builder.confidence;
        this.id = builder.id;
    }

    public boolean hasBodyParts() {
        return this.bodyParts != null && !(this.bodyParts instanceof SdkAutoConstructList);
    }

    public List<ProtectiveEquipmentBodyPart> bodyParts() {
        return this.bodyParts;
    }

    public BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public Float confidence() {
        return this.confidence;
    }

    public Integer id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bodyParts());
        hashCode = 31 * hashCode + Objects.hashCode(this.boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectiveEquipmentPerson)) {
            return false;
        }
        ProtectiveEquipmentPerson other = (ProtectiveEquipmentPerson)obj;
        return Objects.equals(this.bodyParts(), other.bodyParts()) && Objects.equals(this.boundingBox(), other.boundingBox()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.id(), other.id());
    }

    public String toString() {
        return ToString.builder((String)"ProtectiveEquipmentPerson").add("BodyParts", this.bodyParts()).add("BoundingBox", (Object)this.boundingBox()).add("Confidence", (Object)this.confidence()).add("Id", (Object)this.id()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BodyParts": {
                return Optional.ofNullable(clazz.cast(this.bodyParts()));
            }
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectiveEquipmentPerson, T> g) {
        return obj -> g.apply((ProtectiveEquipmentPerson)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ProtectiveEquipmentBodyPart> bodyParts = DefaultSdkAutoConstructList.getInstance();
        private BoundingBox boundingBox;
        private Float confidence;
        private Integer id;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectiveEquipmentPerson model) {
            this.bodyParts(model.bodyParts);
            this.boundingBox(model.boundingBox);
            this.confidence(model.confidence);
            this.id(model.id);
        }

        public final Collection<ProtectiveEquipmentBodyPart.Builder> getBodyParts() {
            return this.bodyParts != null ? (Collection)this.bodyParts.stream().map(ProtectiveEquipmentBodyPart::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bodyParts(Collection<ProtectiveEquipmentBodyPart> bodyParts) {
            this.bodyParts = BodyPartsCopier.copy(bodyParts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bodyParts(ProtectiveEquipmentBodyPart ... bodyParts) {
            this.bodyParts(Arrays.asList(bodyParts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bodyParts(Consumer<ProtectiveEquipmentBodyPart.Builder> ... bodyParts) {
            this.bodyParts(Stream.of(bodyParts).map(c -> (ProtectiveEquipmentBodyPart)((ProtectiveEquipmentBodyPart.Builder)ProtectiveEquipmentBodyPart.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBodyParts(Collection<ProtectiveEquipmentBodyPart.BuilderImpl> bodyParts) {
            this.bodyParts = BodyPartsCopier.copyFromBuilder(bodyParts);
        }

        public final BoundingBox.Builder getBoundingBox() {
            return this.boundingBox != null ? this.boundingBox.toBuilder() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public final Integer getId() {
            return this.id;
        }

        @Override
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public ProtectiveEquipmentPerson build() {
            return new ProtectiveEquipmentPerson(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtectiveEquipmentPerson> {
        public Builder bodyParts(Collection<ProtectiveEquipmentBodyPart> var1);

        public Builder bodyParts(ProtectiveEquipmentBodyPart ... var1);

        public Builder bodyParts(Consumer<ProtectiveEquipmentBodyPart.Builder> ... var1);

        public Builder boundingBox(BoundingBox var1);

        default public Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return this.boundingBox((BoundingBox)((BoundingBox.Builder)BoundingBox.builder().applyMutation(boundingBox)).build());
        }

        public Builder confidence(Float var1);

        public Builder id(Integer var1);
    }
}

