/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.EvaluationResult;
import software.amazon.awssdk.services.rekognition.model.OutputConfig;
import software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus;
import software.amazon.awssdk.services.rekognition.model.TestingDataResult;
import software.amazon.awssdk.services.rekognition.model.TrainingDataResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectVersionDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectVersionDescription> {
    private static final SdkField<String> PROJECT_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectVersionDescription.getter(ProjectVersionDescription::projectVersionArn)).setter(ProjectVersionDescription.setter(Builder::projectVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectVersionArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ProjectVersionDescription.getter(ProjectVersionDescription::creationTimestamp)).setter(ProjectVersionDescription.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<Integer> MIN_INFERENCE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ProjectVersionDescription.getter(ProjectVersionDescription::minInferenceUnits)).setter(ProjectVersionDescription.setter(Builder::minInferenceUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinInferenceUnits").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectVersionDescription.getter(ProjectVersionDescription::statusAsString)).setter(ProjectVersionDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectVersionDescription.getter(ProjectVersionDescription::statusMessage)).setter(ProjectVersionDescription.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Long> BILLABLE_TRAINING_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(ProjectVersionDescription.getter(ProjectVersionDescription::billableTrainingTimeInSeconds)).setter(ProjectVersionDescription.setter(Builder::billableTrainingTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillableTrainingTimeInSeconds").build()}).build();
    private static final SdkField<Instant> TRAINING_END_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ProjectVersionDescription.getter(ProjectVersionDescription::trainingEndTimestamp)).setter(ProjectVersionDescription.setter(Builder::trainingEndTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingEndTimestamp").build()}).build();
    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ProjectVersionDescription.getter(ProjectVersionDescription::outputConfig)).setter(ProjectVersionDescription.setter(Builder::outputConfig)).constructor(OutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<TrainingDataResult> TRAINING_DATA_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ProjectVersionDescription.getter(ProjectVersionDescription::trainingDataResult)).setter(ProjectVersionDescription.setter(Builder::trainingDataResult)).constructor(TrainingDataResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataResult").build()}).build();
    private static final SdkField<TestingDataResult> TESTING_DATA_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ProjectVersionDescription.getter(ProjectVersionDescription::testingDataResult)).setter(ProjectVersionDescription.setter(Builder::testingDataResult)).constructor(TestingDataResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestingDataResult").build()}).build();
    private static final SdkField<EvaluationResult> EVALUATION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ProjectVersionDescription.getter(ProjectVersionDescription::evaluationResult)).setter(ProjectVersionDescription.setter(Builder::evaluationResult)).constructor(EvaluationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_VERSION_ARN_FIELD, CREATION_TIMESTAMP_FIELD, MIN_INFERENCE_UNITS_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, BILLABLE_TRAINING_TIME_IN_SECONDS_FIELD, TRAINING_END_TIMESTAMP_FIELD, OUTPUT_CONFIG_FIELD, TRAINING_DATA_RESULT_FIELD, TESTING_DATA_RESULT_FIELD, EVALUATION_RESULT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String projectVersionArn;
    private final Instant creationTimestamp;
    private final Integer minInferenceUnits;
    private final String status;
    private final String statusMessage;
    private final Long billableTrainingTimeInSeconds;
    private final Instant trainingEndTimestamp;
    private final OutputConfig outputConfig;
    private final TrainingDataResult trainingDataResult;
    private final TestingDataResult testingDataResult;
    private final EvaluationResult evaluationResult;

    private ProjectVersionDescription(BuilderImpl builder) {
        this.projectVersionArn = builder.projectVersionArn;
        this.creationTimestamp = builder.creationTimestamp;
        this.minInferenceUnits = builder.minInferenceUnits;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.billableTrainingTimeInSeconds = builder.billableTrainingTimeInSeconds;
        this.trainingEndTimestamp = builder.trainingEndTimestamp;
        this.outputConfig = builder.outputConfig;
        this.trainingDataResult = builder.trainingDataResult;
        this.testingDataResult = builder.testingDataResult;
        this.evaluationResult = builder.evaluationResult;
    }

    public String projectVersionArn() {
        return this.projectVersionArn;
    }

    public Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public Integer minInferenceUnits() {
        return this.minInferenceUnits;
    }

    public ProjectVersionStatus status() {
        return ProjectVersionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Long billableTrainingTimeInSeconds() {
        return this.billableTrainingTimeInSeconds;
    }

    public Instant trainingEndTimestamp() {
        return this.trainingEndTimestamp;
    }

    public OutputConfig outputConfig() {
        return this.outputConfig;
    }

    public TrainingDataResult trainingDataResult() {
        return this.trainingDataResult;
    }

    public TestingDataResult testingDataResult() {
        return this.testingDataResult;
    }

    public EvaluationResult evaluationResult() {
        return this.evaluationResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.minInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.billableTrainingTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingEndTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.testingDataResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationResult());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectVersionDescription)) {
            return false;
        }
        ProjectVersionDescription other = (ProjectVersionDescription)obj;
        return Objects.equals(this.projectVersionArn(), other.projectVersionArn()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.minInferenceUnits(), other.minInferenceUnits()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.billableTrainingTimeInSeconds(), other.billableTrainingTimeInSeconds()) && Objects.equals(this.trainingEndTimestamp(), other.trainingEndTimestamp()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.trainingDataResult(), other.trainingDataResult()) && Objects.equals(this.testingDataResult(), other.testingDataResult()) && Objects.equals(this.evaluationResult(), other.evaluationResult());
    }

    public String toString() {
        return ToString.builder((String)"ProjectVersionDescription").add("ProjectVersionArn", (Object)this.projectVersionArn()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("MinInferenceUnits", (Object)this.minInferenceUnits()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("BillableTrainingTimeInSeconds", (Object)this.billableTrainingTimeInSeconds()).add("TrainingEndTimestamp", (Object)this.trainingEndTimestamp()).add("OutputConfig", (Object)this.outputConfig()).add("TrainingDataResult", (Object)this.trainingDataResult()).add("TestingDataResult", (Object)this.testingDataResult()).add("EvaluationResult", (Object)this.evaluationResult()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectVersionArn": {
                return Optional.ofNullable(clazz.cast(this.projectVersionArn()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "MinInferenceUnits": {
                return Optional.ofNullable(clazz.cast(this.minInferenceUnits()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "BillableTrainingTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.billableTrainingTimeInSeconds()));
            }
            case "TrainingEndTimestamp": {
                return Optional.ofNullable(clazz.cast(this.trainingEndTimestamp()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "TrainingDataResult": {
                return Optional.ofNullable(clazz.cast(this.trainingDataResult()));
            }
            case "TestingDataResult": {
                return Optional.ofNullable(clazz.cast(this.testingDataResult()));
            }
            case "EvaluationResult": {
                return Optional.ofNullable(clazz.cast(this.evaluationResult()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectVersionDescription, T> g) {
        return obj -> g.apply((ProjectVersionDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String projectVersionArn;
        private Instant creationTimestamp;
        private Integer minInferenceUnits;
        private String status;
        private String statusMessage;
        private Long billableTrainingTimeInSeconds;
        private Instant trainingEndTimestamp;
        private OutputConfig outputConfig;
        private TrainingDataResult trainingDataResult;
        private TestingDataResult testingDataResult;
        private EvaluationResult evaluationResult;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectVersionDescription model) {
            this.projectVersionArn(model.projectVersionArn);
            this.creationTimestamp(model.creationTimestamp);
            this.minInferenceUnits(model.minInferenceUnits);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.billableTrainingTimeInSeconds(model.billableTrainingTimeInSeconds);
            this.trainingEndTimestamp(model.trainingEndTimestamp);
            this.outputConfig(model.outputConfig);
            this.trainingDataResult(model.trainingDataResult);
            this.testingDataResult(model.testingDataResult);
            this.evaluationResult(model.evaluationResult);
        }

        public final String getProjectVersionArn() {
            return this.projectVersionArn;
        }

        @Override
        public final Builder projectVersionArn(String projectVersionArn) {
            this.projectVersionArn = projectVersionArn;
            return this;
        }

        public final void setProjectVersionArn(String projectVersionArn) {
            this.projectVersionArn = projectVersionArn;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final Integer getMinInferenceUnits() {
            return this.minInferenceUnits;
        }

        @Override
        public final Builder minInferenceUnits(Integer minInferenceUnits) {
            this.minInferenceUnits = minInferenceUnits;
            return this;
        }

        public final void setMinInferenceUnits(Integer minInferenceUnits) {
            this.minInferenceUnits = minInferenceUnits;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProjectVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Long getBillableTrainingTimeInSeconds() {
            return this.billableTrainingTimeInSeconds;
        }

        @Override
        public final Builder billableTrainingTimeInSeconds(Long billableTrainingTimeInSeconds) {
            this.billableTrainingTimeInSeconds = billableTrainingTimeInSeconds;
            return this;
        }

        public final void setBillableTrainingTimeInSeconds(Long billableTrainingTimeInSeconds) {
            this.billableTrainingTimeInSeconds = billableTrainingTimeInSeconds;
        }

        public final Instant getTrainingEndTimestamp() {
            return this.trainingEndTimestamp;
        }

        @Override
        public final Builder trainingEndTimestamp(Instant trainingEndTimestamp) {
            this.trainingEndTimestamp = trainingEndTimestamp;
            return this;
        }

        public final void setTrainingEndTimestamp(Instant trainingEndTimestamp) {
            this.trainingEndTimestamp = trainingEndTimestamp;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        public final TrainingDataResult.Builder getTrainingDataResult() {
            return this.trainingDataResult != null ? this.trainingDataResult.toBuilder() : null;
        }

        @Override
        public final Builder trainingDataResult(TrainingDataResult trainingDataResult) {
            this.trainingDataResult = trainingDataResult;
            return this;
        }

        public final void setTrainingDataResult(TrainingDataResult.BuilderImpl trainingDataResult) {
            this.trainingDataResult = trainingDataResult != null ? trainingDataResult.build() : null;
        }

        public final TestingDataResult.Builder getTestingDataResult() {
            return this.testingDataResult != null ? this.testingDataResult.toBuilder() : null;
        }

        @Override
        public final Builder testingDataResult(TestingDataResult testingDataResult) {
            this.testingDataResult = testingDataResult;
            return this;
        }

        public final void setTestingDataResult(TestingDataResult.BuilderImpl testingDataResult) {
            this.testingDataResult = testingDataResult != null ? testingDataResult.build() : null;
        }

        public final EvaluationResult.Builder getEvaluationResult() {
            return this.evaluationResult != null ? this.evaluationResult.toBuilder() : null;
        }

        @Override
        public final Builder evaluationResult(EvaluationResult evaluationResult) {
            this.evaluationResult = evaluationResult;
            return this;
        }

        public final void setEvaluationResult(EvaluationResult.BuilderImpl evaluationResult) {
            this.evaluationResult = evaluationResult != null ? evaluationResult.build() : null;
        }

        public ProjectVersionDescription build() {
            return new ProjectVersionDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectVersionDescription> {
        public Builder projectVersionArn(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder minInferenceUnits(Integer var1);

        public Builder status(String var1);

        public Builder status(ProjectVersionStatus var1);

        public Builder statusMessage(String var1);

        public Builder billableTrainingTimeInSeconds(Long var1);

        public Builder trainingEndTimestamp(Instant var1);

        public Builder outputConfig(OutputConfig var1);

        default public Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return this.outputConfig((OutputConfig)((OutputConfig.Builder)OutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder trainingDataResult(TrainingDataResult var1);

        default public Builder trainingDataResult(Consumer<TrainingDataResult.Builder> trainingDataResult) {
            return this.trainingDataResult((TrainingDataResult)((TrainingDataResult.Builder)TrainingDataResult.builder().applyMutation(trainingDataResult)).build());
        }

        public Builder testingDataResult(TestingDataResult var1);

        default public Builder testingDataResult(Consumer<TestingDataResult.Builder> testingDataResult) {
            return this.testingDataResult((TestingDataResult)((TestingDataResult.Builder)TestingDataResult.builder().applyMutation(testingDataResult)).build());
        }

        public Builder evaluationResult(EvaluationResult var1);

        default public Builder evaluationResult(Consumer<EvaluationResult.Builder> evaluationResult) {
            return this.evaluationResult((EvaluationResult)((EvaluationResult.Builder)EvaluationResult.builder().applyMutation(evaluationResult)).build());
        }
    }
}

