/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.ProjectStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectDescription> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectDescription.getter(ProjectDescription::projectArn)).setter(ProjectDescription.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ProjectDescription.getter(ProjectDescription::creationTimestamp)).setter(ProjectDescription.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectDescription.getter(ProjectDescription::statusAsString)).setter(ProjectDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, CREATION_TIMESTAMP_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String projectArn;
    private final Instant creationTimestamp;
    private final String status;

    private ProjectDescription(BuilderImpl builder) {
        this.projectArn = builder.projectArn;
        this.creationTimestamp = builder.creationTimestamp;
        this.status = builder.status;
    }

    public String projectArn() {
        return this.projectArn;
    }

    public Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public ProjectStatus status() {
        return ProjectStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectDescription)) {
            return false;
        }
        ProjectDescription other = (ProjectDescription)obj;
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"ProjectDescription").add("ProjectArn", (Object)this.projectArn()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectDescription, T> g) {
        return obj -> g.apply((ProjectDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String projectArn;
        private Instant creationTimestamp;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectDescription model) {
            this.projectArn(model.projectArn);
            this.creationTimestamp(model.creationTimestamp);
            this.status(model.status);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProjectStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public ProjectDescription build() {
            return new ProjectDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectDescription> {
        public Builder projectArn(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(ProjectStatus var1);
    }
}

