/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.AccessDeniedException;
import software.amazon.awssdk.services.rekognition.model.CompareFacesRequest;
import software.amazon.awssdk.services.rekognition.model.CompareFacesResponse;
import software.amazon.awssdk.services.rekognition.model.CreateCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.CreateCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.CreateProjectRequest;
import software.amazon.awssdk.services.rekognition.model.CreateProjectResponse;
import software.amazon.awssdk.services.rekognition.model.CreateProjectVersionRequest;
import software.amazon.awssdk.services.rekognition.model.CreateProjectVersionResponse;
import software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectsRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectsResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.DetectCustomLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectCustomLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.DetectFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DetectFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.DetectTextRequest;
import software.amazon.awssdk.services.rekognition.model.DetectTextResponse;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoRequest;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoResponse;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionRequest;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionResponse;
import software.amazon.awssdk.services.rekognition.model.GetContentModerationRequest;
import software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse;
import software.amazon.awssdk.services.rekognition.model.GetFaceDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.GetFaceSearchRequest;
import software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse;
import software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.GetPersonTrackingRequest;
import software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse;
import software.amazon.awssdk.services.rekognition.model.HumanLoopQuotaExceededException;
import software.amazon.awssdk.services.rekognition.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.rekognition.model.ImageTooLargeException;
import software.amazon.awssdk.services.rekognition.model.IndexFacesRequest;
import software.amazon.awssdk.services.rekognition.model.IndexFacesResponse;
import software.amazon.awssdk.services.rekognition.model.InternalServerErrorException;
import software.amazon.awssdk.services.rekognition.model.InvalidImageFormatException;
import software.amazon.awssdk.services.rekognition.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.rekognition.model.InvalidParameterException;
import software.amazon.awssdk.services.rekognition.model.InvalidS3ObjectException;
import software.amazon.awssdk.services.rekognition.model.LimitExceededException;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse;
import software.amazon.awssdk.services.rekognition.model.ListFacesRequest;
import software.amazon.awssdk.services.rekognition.model.ListFacesResponse;
import software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest;
import software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse;
import software.amazon.awssdk.services.rekognition.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesRequest;
import software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse;
import software.amazon.awssdk.services.rekognition.model.RekognitionException;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.services.rekognition.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.rekognition.model.ResourceInUseException;
import software.amazon.awssdk.services.rekognition.model.ResourceNotFoundException;
import software.amazon.awssdk.services.rekognition.model.ResourceNotReadyException;
import software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest;
import software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse;
import software.amazon.awssdk.services.rekognition.model.SearchFacesRequest;
import software.amazon.awssdk.services.rekognition.model.SearchFacesResponse;
import software.amazon.awssdk.services.rekognition.model.StartCelebrityRecognitionRequest;
import software.amazon.awssdk.services.rekognition.model.StartCelebrityRecognitionResponse;
import software.amazon.awssdk.services.rekognition.model.StartContentModerationRequest;
import software.amazon.awssdk.services.rekognition.model.StartContentModerationResponse;
import software.amazon.awssdk.services.rekognition.model.StartFaceDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.StartFaceDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.StartFaceSearchRequest;
import software.amazon.awssdk.services.rekognition.model.StartFaceSearchResponse;
import software.amazon.awssdk.services.rekognition.model.StartLabelDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.StartLabelDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.StartPersonTrackingRequest;
import software.amazon.awssdk.services.rekognition.model.StartPersonTrackingResponse;
import software.amazon.awssdk.services.rekognition.model.StartProjectVersionRequest;
import software.amazon.awssdk.services.rekognition.model.StartProjectVersionResponse;
import software.amazon.awssdk.services.rekognition.model.StartStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.StartStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.StopProjectVersionRequest;
import software.amazon.awssdk.services.rekognition.model.StopProjectVersionResponse;
import software.amazon.awssdk.services.rekognition.model.StopStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.StopStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.ThrottlingException;
import software.amazon.awssdk.services.rekognition.model.VideoTooLargeException;
import software.amazon.awssdk.services.rekognition.paginators.DescribeProjectVersionsIterable;
import software.amazon.awssdk.services.rekognition.paginators.DescribeProjectsIterable;
import software.amazon.awssdk.services.rekognition.paginators.GetCelebrityRecognitionIterable;
import software.amazon.awssdk.services.rekognition.paginators.GetContentModerationIterable;
import software.amazon.awssdk.services.rekognition.paginators.GetFaceDetectionIterable;
import software.amazon.awssdk.services.rekognition.paginators.GetFaceSearchIterable;
import software.amazon.awssdk.services.rekognition.paginators.GetLabelDetectionIterable;
import software.amazon.awssdk.services.rekognition.paginators.GetPersonTrackingIterable;
import software.amazon.awssdk.services.rekognition.paginators.ListCollectionsIterable;
import software.amazon.awssdk.services.rekognition.paginators.ListFacesIterable;
import software.amazon.awssdk.services.rekognition.paginators.ListStreamProcessorsIterable;
import software.amazon.awssdk.services.rekognition.transform.CompareFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateCollectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateProjectVersionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteCollectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeCollectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeProjectVersionsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeProjectsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectCustomLabelsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectLabelsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectModerationLabelsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectTextRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetCelebrityInfoRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetCelebrityRecognitionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetContentModerationRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetFaceDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetFaceSearchRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetLabelDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetPersonTrackingRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.IndexFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListCollectionsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListStreamProcessorsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.RecognizeCelebritiesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesByImageRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartCelebrityRecognitionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartContentModerationRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartFaceDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartFaceSearchRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartLabelDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartPersonTrackingRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartProjectVersionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StopProjectVersionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StopStreamProcessorRequestMarshaller;

@SdkInternalApi
final class DefaultRekognitionClient
implements RekognitionClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRekognitionClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "rekognition";
    }

    @Override
    public CompareFacesResponse compareFaces(CompareFacesRequest compareFacesRequest) throws InvalidParameterException, InvalidS3ObjectException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CompareFacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CompareFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CompareFaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)compareFacesRequest).withMarshaller((Marshaller)new CompareFacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateCollectionResponse createCollection(CreateCollectionRequest createCollectionRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCollectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCollection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCollectionRequest).withMarshaller((Marshaller)new CreateCollectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws ResourceInUseException, LimitExceededException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateProjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateProject").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createProjectRequest).withMarshaller((Marshaller)new CreateProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateProjectVersionResponse createProjectVersion(CreateProjectVersionRequest createProjectVersionRequest) throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateProjectVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateProjectVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateProjectVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createProjectVersionRequest).withMarshaller((Marshaller)new CreateProjectVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateStreamProcessorResponse createStreamProcessor(CreateStreamProcessorRequest createStreamProcessorRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, LimitExceededException, ResourceInUseException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStreamProcessorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateStreamProcessorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStreamProcessor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createStreamProcessorRequest).withMarshaller((Marshaller)new CreateStreamProcessorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteCollectionResponse deleteCollection(DeleteCollectionRequest deleteCollectionRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCollectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCollection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCollectionRequest).withMarshaller((Marshaller)new DeleteCollectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteFacesResponse deleteFaces(DeleteFacesRequest deleteFacesRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFacesRequest).withMarshaller((Marshaller)new DeleteFacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteStreamProcessorResponse deleteStreamProcessor(DeleteStreamProcessorRequest deleteStreamProcessorRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, ResourceNotFoundException, ResourceInUseException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStreamProcessorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteStreamProcessorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStreamProcessor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteStreamProcessorRequest).withMarshaller((Marshaller)new DeleteStreamProcessorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeCollectionResponse describeCollection(DescribeCollectionRequest describeCollectionRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCollectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCollection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCollectionRequest).withMarshaller((Marshaller)new DescribeCollectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeProjectVersionsResponse describeProjectVersions(DescribeProjectVersionsRequest describeProjectVersionsRequest) throws ResourceNotFoundException, InvalidPaginationTokenException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeProjectVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeProjectVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeProjectVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeProjectVersionsRequest).withMarshaller((Marshaller)new DescribeProjectVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeProjectVersionsIterable describeProjectVersionsPaginator(DescribeProjectVersionsRequest describeProjectVersionsRequest) throws ResourceNotFoundException, InvalidPaginationTokenException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        return new DescribeProjectVersionsIterable(this, this.applyPaginatorUserAgent(describeProjectVersionsRequest));
    }

    @Override
    public DescribeProjectsResponse describeProjects(DescribeProjectsRequest describeProjectsRequest) throws InvalidPaginationTokenException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeProjectsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeProjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeProjects").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeProjectsRequest).withMarshaller((Marshaller)new DescribeProjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeProjectsIterable describeProjectsPaginator(DescribeProjectsRequest describeProjectsRequest) throws InvalidPaginationTokenException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        return new DescribeProjectsIterable(this, this.applyPaginatorUserAgent(describeProjectsRequest));
    }

    @Override
    public DescribeStreamProcessorResponse describeStreamProcessor(DescribeStreamProcessorRequest describeStreamProcessorRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, ResourceNotFoundException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStreamProcessorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeStreamProcessorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStreamProcessor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStreamProcessorRequest).withMarshaller((Marshaller)new DescribeStreamProcessorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DetectCustomLabelsResponse detectCustomLabels(DetectCustomLabelsRequest detectCustomLabelsRequest) throws ResourceNotFoundException, ResourceNotReadyException, InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, LimitExceededException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectCustomLabelsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DetectCustomLabelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectCustomLabels").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectCustomLabelsRequest).withMarshaller((Marshaller)new DetectCustomLabelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DetectFacesResponse detectFaces(DetectFacesRequest detectFacesRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectFacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DetectFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectFaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectFacesRequest).withMarshaller((Marshaller)new DetectFacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DetectLabelsResponse detectLabels(DetectLabelsRequest detectLabelsRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectLabelsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DetectLabelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectLabels").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectLabelsRequest).withMarshaller((Marshaller)new DetectLabelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DetectModerationLabelsResponse detectModerationLabels(DetectModerationLabelsRequest detectModerationLabelsRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, HumanLoopQuotaExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectModerationLabelsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DetectModerationLabelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectModerationLabels").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectModerationLabelsRequest).withMarshaller((Marshaller)new DetectModerationLabelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DetectTextResponse detectText(DetectTextRequest detectTextRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectTextResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DetectTextResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectText").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectTextRequest).withMarshaller((Marshaller)new DetectTextRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetCelebrityInfoResponse getCelebrityInfo(GetCelebrityInfoRequest getCelebrityInfoRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCelebrityInfoResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetCelebrityInfoResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCelebrityInfo").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCelebrityInfoRequest).withMarshaller((Marshaller)new GetCelebrityInfoRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetCelebrityRecognitionResponse getCelebrityRecognition(GetCelebrityRecognitionRequest getCelebrityRecognitionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCelebrityRecognitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetCelebrityRecognitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCelebrityRecognition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCelebrityRecognitionRequest).withMarshaller((Marshaller)new GetCelebrityRecognitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetCelebrityRecognitionIterable getCelebrityRecognitionPaginator(GetCelebrityRecognitionRequest getCelebrityRecognitionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        return new GetCelebrityRecognitionIterable(this, this.applyPaginatorUserAgent(getCelebrityRecognitionRequest));
    }

    @Override
    public GetContentModerationResponse getContentModeration(GetContentModerationRequest getContentModerationRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContentModerationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetContentModerationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContentModeration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getContentModerationRequest).withMarshaller((Marshaller)new GetContentModerationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetContentModerationIterable getContentModerationPaginator(GetContentModerationRequest getContentModerationRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        return new GetContentModerationIterable(this, this.applyPaginatorUserAgent(getContentModerationRequest));
    }

    @Override
    public GetFaceDetectionResponse getFaceDetection(GetFaceDetectionRequest getFaceDetectionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFaceDetectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetFaceDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFaceDetection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFaceDetectionRequest).withMarshaller((Marshaller)new GetFaceDetectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetFaceDetectionIterable getFaceDetectionPaginator(GetFaceDetectionRequest getFaceDetectionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        return new GetFaceDetectionIterable(this, this.applyPaginatorUserAgent(getFaceDetectionRequest));
    }

    @Override
    public GetFaceSearchResponse getFaceSearch(GetFaceSearchRequest getFaceSearchRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFaceSearchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetFaceSearchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFaceSearch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFaceSearchRequest).withMarshaller((Marshaller)new GetFaceSearchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetFaceSearchIterable getFaceSearchPaginator(GetFaceSearchRequest getFaceSearchRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        return new GetFaceSearchIterable(this, this.applyPaginatorUserAgent(getFaceSearchRequest));
    }

    @Override
    public GetLabelDetectionResponse getLabelDetection(GetLabelDetectionRequest getLabelDetectionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLabelDetectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetLabelDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLabelDetection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLabelDetectionRequest).withMarshaller((Marshaller)new GetLabelDetectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetLabelDetectionIterable getLabelDetectionPaginator(GetLabelDetectionRequest getLabelDetectionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        return new GetLabelDetectionIterable(this, this.applyPaginatorUserAgent(getLabelDetectionRequest));
    }

    @Override
    public GetPersonTrackingResponse getPersonTracking(GetPersonTrackingRequest getPersonTrackingRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPersonTrackingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetPersonTrackingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPersonTracking").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPersonTrackingRequest).withMarshaller((Marshaller)new GetPersonTrackingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetPersonTrackingIterable getPersonTrackingPaginator(GetPersonTrackingRequest getPersonTrackingRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        return new GetPersonTrackingIterable(this, this.applyPaginatorUserAgent(getPersonTrackingRequest));
    }

    @Override
    public IndexFacesResponse indexFaces(IndexFacesRequest indexFacesRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, IndexFacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (IndexFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("IndexFaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)indexFacesRequest).withMarshaller((Marshaller)new IndexFacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListCollectionsResponse listCollections(ListCollectionsRequest listCollectionsRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidPaginationTokenException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCollectionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListCollectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCollections").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCollectionsRequest).withMarshaller((Marshaller)new ListCollectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListCollectionsIterable listCollectionsPaginator(ListCollectionsRequest listCollectionsRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidPaginationTokenException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        return new ListCollectionsIterable(this, this.applyPaginatorUserAgent(listCollectionsRequest));
    }

    @Override
    public ListFacesResponse listFaces(ListFacesRequest listFacesRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidPaginationTokenException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFacesRequest).withMarshaller((Marshaller)new ListFacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListFacesIterable listFacesPaginator(ListFacesRequest listFacesRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidPaginationTokenException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        return new ListFacesIterable(this, this.applyPaginatorUserAgent(listFacesRequest));
    }

    @Override
    public ListStreamProcessorsResponse listStreamProcessors(ListStreamProcessorsRequest listStreamProcessorsRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStreamProcessorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListStreamProcessorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStreamProcessors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listStreamProcessorsRequest).withMarshaller((Marshaller)new ListStreamProcessorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListStreamProcessorsIterable listStreamProcessorsPaginator(ListStreamProcessorsRequest listStreamProcessorsRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        return new ListStreamProcessorsIterable(this, this.applyPaginatorUserAgent(listStreamProcessorsRequest));
    }

    @Override
    public RecognizeCelebritiesResponse recognizeCelebrities(RecognizeCelebritiesRequest recognizeCelebritiesRequest) throws InvalidS3ObjectException, InvalidParameterException, InvalidImageFormatException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RecognizeCelebritiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RecognizeCelebritiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RecognizeCelebrities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)recognizeCelebritiesRequest).withMarshaller((Marshaller)new RecognizeCelebritiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SearchFacesResponse searchFaces(SearchFacesRequest searchFacesRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchFacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SearchFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchFaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchFacesRequest).withMarshaller((Marshaller)new SearchFacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SearchFacesByImageResponse searchFacesByImage(SearchFacesByImageRequest searchFacesByImageRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchFacesByImageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SearchFacesByImageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchFacesByImage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchFacesByImageRequest).withMarshaller((Marshaller)new SearchFacesByImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartCelebrityRecognitionResponse startCelebrityRecognition(StartCelebrityRecognitionRequest startCelebrityRecognitionRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartCelebrityRecognitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartCelebrityRecognitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartCelebrityRecognition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startCelebrityRecognitionRequest).withMarshaller((Marshaller)new StartCelebrityRecognitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartContentModerationResponse startContentModeration(StartContentModerationRequest startContentModerationRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartContentModerationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartContentModerationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartContentModeration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startContentModerationRequest).withMarshaller((Marshaller)new StartContentModerationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartFaceDetectionResponse startFaceDetection(StartFaceDetectionRequest startFaceDetectionRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartFaceDetectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartFaceDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartFaceDetection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startFaceDetectionRequest).withMarshaller((Marshaller)new StartFaceDetectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartFaceSearchResponse startFaceSearch(StartFaceSearchRequest startFaceSearchRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartFaceSearchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartFaceSearchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartFaceSearch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startFaceSearchRequest).withMarshaller((Marshaller)new StartFaceSearchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartLabelDetectionResponse startLabelDetection(StartLabelDetectionRequest startLabelDetectionRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartLabelDetectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartLabelDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartLabelDetection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startLabelDetectionRequest).withMarshaller((Marshaller)new StartLabelDetectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartPersonTrackingResponse startPersonTracking(StartPersonTrackingRequest startPersonTrackingRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartPersonTrackingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartPersonTrackingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartPersonTracking").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startPersonTrackingRequest).withMarshaller((Marshaller)new StartPersonTrackingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartProjectVersionResponse startProjectVersion(StartProjectVersionRequest startProjectVersionRequest) throws ResourceNotFoundException, ResourceInUseException, LimitExceededException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartProjectVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartProjectVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartProjectVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startProjectVersionRequest).withMarshaller((Marshaller)new StartProjectVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartStreamProcessorResponse startStreamProcessor(StartStreamProcessorRequest startStreamProcessorRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, ResourceNotFoundException, ResourceInUseException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartStreamProcessorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartStreamProcessorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartStreamProcessor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startStreamProcessorRequest).withMarshaller((Marshaller)new StartStreamProcessorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopProjectVersionResponse stopProjectVersion(StopProjectVersionRequest stopProjectVersionRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopProjectVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopProjectVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopProjectVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopProjectVersionRequest).withMarshaller((Marshaller)new StopProjectVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopStreamProcessorResponse stopStreamProcessor(StopStreamProcessorRequest stopStreamProcessorRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, ResourceNotFoundException, ResourceInUseException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopStreamProcessorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopStreamProcessorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopStreamProcessor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopStreamProcessorRequest).withMarshaller((Marshaller)new StopStreamProcessorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(RekognitionException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").exceptionBuilderSupplier(ResourceNotReadyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidImageFormatException").exceptionBuilderSupplier(InvalidImageFormatException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").exceptionBuilderSupplier(InvalidS3ObjectException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("VideoTooLargeException").exceptionBuilderSupplier(VideoTooLargeException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ImageTooLargeException").exceptionBuilderSupplier(ImageTooLargeException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerError").exceptionBuilderSupplier(InternalServerErrorException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends RekognitionRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.10.63").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RekognitionRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

