/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.SearchFacesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SearchFacesRequestModelMarshaller {
    private static final MarshallingInfo<String> COLLECTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CollectionId").isBinary(false).build();
    private static final MarshallingInfo<String> FACEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FaceId").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXFACES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxFaces").isBinary(false).build();
    private static final MarshallingInfo<Float> FACEMATCHTHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FaceMatchThreshold").isBinary(false).build();
    private static final SearchFacesRequestModelMarshaller INSTANCE = new SearchFacesRequestModelMarshaller();

    private SearchFacesRequestModelMarshaller() {
    }

    public static SearchFacesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SearchFacesRequest searchFacesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)searchFacesRequest), (String)"searchFacesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)searchFacesRequest.collectionId(), COLLECTIONID_BINDING);
            protocolMarshaller.marshall((Object)searchFacesRequest.faceId(), FACEID_BINDING);
            protocolMarshaller.marshall((Object)searchFacesRequest.maxFaces(), MAXFACES_BINDING);
            protocolMarshaller.marshall((Object)searchFacesRequest.faceMatchThreshold(), FACEMATCHTHRESHOLD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

